/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.server.web.HttpHeaderUtils;

public class HttpHeaderUtilsTest {
    @Rule
    public AssertableLogProvider logProvider = new AssertableLogProvider(true);
    private HttpServletRequest request;

    @Before
    public void setUp() {
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    }

    @Test
    public void retrieveCustomTransactionTimeout() {
        Mockito.when((Object)this.request.getHeader("max-execution-time")).thenReturn((Object)"100");
        Log log = this.logProvider.getLog(HttpServletRequest.class);
        long transactionTimeout = HttpHeaderUtils.getTransactionTimeout((HttpServletRequest)this.request, (Log)log);
        Assert.assertEquals((String)"Transaction timeout should be retrieved.", (long)100L, (long)transactionTimeout);
        this.logProvider.assertNoLoggingOccurred();
    }

    @Test
    public void defaultValueWhenCustomTransactionTimeoutNotSpecified() {
        Log log = this.logProvider.getLog(HttpServletRequest.class);
        long transactionTimeout = HttpHeaderUtils.getTransactionTimeout((HttpServletRequest)this.request, (Log)log);
        Assert.assertEquals((String)"Transaction timeout not specified.", (long)0L, (long)transactionTimeout);
        this.logProvider.assertNoLoggingOccurred();
    }

    @Test
    public void defaultValueWhenCustomTransactionTimeoutNotANumber() {
        Mockito.when((Object)this.request.getHeader("max-execution-time")).thenReturn((Object)"aa");
        Log log = this.logProvider.getLog(HttpServletRequest.class);
        long transactionTimeout = HttpHeaderUtils.getTransactionTimeout((HttpServletRequest)this.request, (Log)log);
        Assert.assertEquals((String)"Transaction timeout not specified.", (long)0L, (long)transactionTimeout);
        this.logProvider.assertContainsMessageContaining("Fail to parse `max-execution-time` header with value: 'aa'. Should be a positive number.");
    }

    @Test
    public void shouldCheckHttpHeaders() {
        Assert.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName(null));
        Assert.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)""));
        Assert.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)" "));
        Assert.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"      "));
        Assert.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)" \r "));
        Assert.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)" \r\n\t "));
        Assert.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"Accept"));
        Assert.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"Accept-Encoding"));
        Assert.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"Age"));
        Assert.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"Content-Encoding"));
        Assert.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"Expires"));
        Assert.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"If-Match"));
        Assert.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"Transfer-Encoding"));
        Assert.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"Weird Header With Spaces"));
        Assert.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"My\nHeader"));
        Assert.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"Other\rStrange-Header"));
        Assert.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"Header-With-Tab\t"));
    }
}

