/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.ServerBootstrapper;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.test.server.ExclusiveServerTestBase;

public abstract class BaseBootstrapperTestIT
extends ExclusiveServerTestBase {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    protected ServerBootstrapper bootstrapper;

    @Before
    public void before() {
        this.bootstrapper = this.newBootstrapper();
    }

    @After
    public void after() {
        if (this.bootstrapper != null) {
            this.bootstrapper.stop();
        }
    }

    protected abstract ServerBootstrapper newBootstrapper();

    @Test
    public void shouldStartStopNeoServerWithoutAnyConfigFiles() throws Throwable {
        int resultCode = ServerBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.tempDir.newFolder("home-dir").getAbsolutePath(), "-c", this.configOption(GraphDatabaseSettings.data_directory, this.tempDir.getRoot().getAbsolutePath()), "-c", this.configOption(GraphDatabaseSettings.logs_directory, this.tempDir.getRoot().getAbsolutePath()), "-c", "dbms.connector.https.listen_address=localhost:0", "-c", "dbms.connector.http.type=HTTP", "-c", "dbms.connector.http.enabled=true", "-c", "dbms.connector.http.listen_address=localhost:" + PortAuthority.allocatePort(), "-c", "dbms.connector.https.type=HTTP", "-c", "dbms.connector.https.enabled=true", "-c", "dbms.connector.https.listen_address=localhost:" + PortAuthority.allocatePort(), "-c", new BoltConnector((String)"bolt").listen_address.name() + "=localhost:" + PortAuthority.allocatePort(), "-c", "dbms.backup.enabled=false"});
        Assert.assertEquals((long)0L, (long)resultCode);
        org.neo4j.test.assertion.Assert.assertEventually((String)"Server was not started", () -> ((ServerBootstrapper)this.bootstrapper).isRunning(), (Matcher)Matchers.is((Object)true), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    @Test
    public void canSpecifyConfigFile() throws Throwable {
        File configFile = this.tempDir.newFile("neo4j.conf");
        Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.forced_kernel_id.name(), "ourcustomvalue"});
        properties.putAll(ServerTestUtils.getDefaultRelativeProperties());
        properties.put("dbms.connector.http.type", "HTTP");
        properties.put("dbms.connector.http.enabled", "true");
        properties.put("dbms.connector.http.listen_address", "localhost:0");
        properties.put(new BoltConnector((String)"bolt").listen_address.name(), "localhost:0");
        MapUtil.store((Map)properties, (File)configFile);
        ServerBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.tempDir.newFolder("home-dir").getAbsolutePath(), "--config-dir", configFile.getParentFile().getAbsolutePath()});
        Assert.assertThat((Object)this.bootstrapper.getServer().getConfig().get(GraphDatabaseSettings.forced_kernel_id), (Matcher)Matchers.equalTo((Object)"ourcustomvalue"));
    }

    @Test
    public void canOverrideConfigValues() throws Throwable {
        File configFile = this.tempDir.newFile("neo4j.conf");
        Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.forced_kernel_id.name(), "thisshouldnotshowup"});
        properties.putAll(ServerTestUtils.getDefaultRelativeProperties());
        properties.put("dbms.connector.http.type", "HTTP");
        properties.put("dbms.connector.http.enabled", "true");
        properties.put("dbms.connector.http.listen_address", "localhost:0");
        properties.put(new BoltConnector((String)"bolt").listen_address.name(), "localhost:0");
        MapUtil.store((Map)properties, (File)configFile);
        ServerBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.tempDir.newFolder("home-dir").getAbsolutePath(), "--config-dir", configFile.getParentFile().getAbsolutePath(), "-c", this.configOption(GraphDatabaseSettings.forced_kernel_id, "mycustomvalue")});
        Assert.assertThat((Object)this.bootstrapper.getServer().getConfig().get(GraphDatabaseSettings.forced_kernel_id), (Matcher)Matchers.equalTo((Object)"mycustomvalue"));
    }

    protected String configOption(Setting<?> setting, String value) {
        return setting.name() + "=" + value;
    }
}

