/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.integration;

import java.util.Arrays;
import org.codehaus.jackson.JsonNode;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.store.GeometryType;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class PointTypeIT
extends AbstractRestFunctionalTestBase {
    @Test
    public void shouldWorkWithPoint2DArrays() throws Exception {
        HTTP.Response response = PointTypeIT.runQuery("create (:Node {points: [point({x:1, y:1}), point({x:2, y:2}), point({x: 3.0, y: 3.0})]})");
        Assert.assertEquals((long)200L, (long)response.status());
        PointTypeIT.assertNoErrors(response);
        GraphDatabaseFacade db = PointTypeIT.server().getDatabase().getGraph();
        try (Transaction tx = db.beginTx();){
            for (Node node : db.getAllNodes()) {
                if (!node.hasLabel(Label.label((String)"Node")) || !node.hasProperty("points")) continue;
                Point[] points = (Point[])node.getProperty("points");
                PointTypeIT.verifyPoint(points[0], (CRS)CoordinateReferenceSystem.Cartesian, 1.0, 1.0);
                PointTypeIT.verifyPoint(points[1], (CRS)CoordinateReferenceSystem.Cartesian, 2.0, 2.0);
                PointTypeIT.verifyPoint(points[2], (CRS)CoordinateReferenceSystem.Cartesian, 3.0, 3.0);
            }
            tx.success();
        }
    }

    @Test
    public void shouldReturnPoint2DWithXAndY() throws Exception {
        PointTypeIT.testPoint("RETURN point({x: 42.05, y: 90.99})", new double[]{42.05, 90.99}, CoordinateReferenceSystem.Cartesian, "point");
    }

    @Test
    public void shouldReturnPoint2DWithLatitudeAndLongitude() throws Exception {
        PointTypeIT.testPoint("RETURN point({longitude: 56.7, latitude: 12.78})", new double[]{56.7, 12.78}, CoordinateReferenceSystem.WGS84, "point");
    }

    private static void testPoint(String query, double[] expectedCoordinate, CoordinateReferenceSystem expectedCrs, String expectedType) throws Exception {
        HTTP.Response response = PointTypeIT.runQuery(query);
        Assert.assertEquals((long)200L, (long)response.status());
        PointTypeIT.assertNoErrors(response);
        JsonNode element = PointTypeIT.extractSingleElement(response);
        PointTypeIT.assertGeometryTypeEqual(GeometryType.GEOMETRY_POINT, element);
        PointTypeIT.assertCoordinatesEqual(expectedCoordinate, element);
        PointTypeIT.assertCrsEqual(expectedCrs, element);
        PointTypeIT.assertTypeEqual(expectedType, response);
    }

    private static void assertTypeEqual(String expectedType, HTTP.Response response) throws JsonParseException {
        JsonNode data = response.get("results").get(0).get("data");
        JsonNode meta = data.get(0).get("meta");
        Assert.assertEquals((long)1L, (long)meta.size());
        Assert.assertEquals((Object)expectedType, (Object)meta.get(0).get("type").asText());
    }

    private static JsonNode extractSingleElement(HTTP.Response response) throws JsonParseException {
        JsonNode data = response.get("results").get(0).get("data");
        Assert.assertEquals((long)1L, (long)data.size());
        JsonNode row = data.get(0).get("row");
        Assert.assertEquals((long)1L, (long)row.size());
        return row.get(0);
    }

    private static void assertGeometryTypeEqual(GeometryType expected, JsonNode element) {
        Assert.assertEquals((Object)expected.getName(), (Object)element.get("type").asText());
    }

    private static void assertCoordinatesEqual(double[] expected, JsonNode element) {
        Assert.assertArrayEquals((double[])expected, (double[])PointTypeIT.coordinatesAsArray(element), (double)1.0E-6);
    }

    private static double[] coordinatesAsArray(JsonNode element) {
        return Iterables.stream((Iterable)element.get("coordinates")).mapToDouble(JsonNode::asDouble).toArray();
    }

    private static void assertCrsEqual(CoordinateReferenceSystem crs, JsonNode element) {
        Assert.assertEquals((Object)crs.getName(), (Object)element.get("crs").get("name").asText());
    }

    private static void verifyPoint(Point point, CRS expectedCRS, Double ... expectedCoordinate) {
        Assert.assertEquals((long)expectedCRS.getCode(), (long)point.getCRS().getCode());
        Assert.assertEquals(Arrays.asList(expectedCoordinate), (Object)point.getCoordinate().getCoordinate());
    }
}

