/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class ServerConfigIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Test
    public void shouldPickUpAddressFromConfig() throws Exception {
        ListenSocketAddress nonDefaultAddress = new ListenSocketAddress("0.0.0.0", 4321);
        this.server = CommunityServerBuilder.server().onAddress(nonDefaultAddress).usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        HostnamePort localHttpAddress = this.getLocalHttpAddress();
        Assert.assertEquals((long)nonDefaultAddress.getPort(), (long)localHttpAddress.getPort());
        Assert.assertEquals((Object)nonDefaultAddress.getHostname(), (Object)localHttpAddress.getHost());
        JaxRsResponse response = new RestRequest(this.server.baseUri()).get();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        response.close();
    }

    @Test
    public void shouldPickupRelativeUrisForManagementApiAndRestApi() throws IOException {
        String dataUri = "a/different/data/uri/";
        String managementUri = "a/different/management/uri/";
        this.server = CommunityServerBuilder.serverOnRandomPorts().withRelativeRestApiUriPath("/" + dataUri).usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).withRelativeManagementApiUriPath("/" + managementUri).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get(this.server.baseUri().toString() + dataUri, MediaType.TEXT_HTML_TYPE);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = new RestRequest().get(this.server.baseUri().toString() + managementUri);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldGenerateWADLWhenExplicitlyEnabledInConfig() throws IOException {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(ServerSettings.wadl_enabled.name(), "true").usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get(this.server.baseUri().toString() + "application.wadl", MediaType.WILDCARD_TYPE);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/vnd.sun.wadl+xml", ((List)response.getHeaders().get((Object)"Content-Type")).iterator().next());
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.containsString((String)"<application xmlns=\"http://wadl.dev.java.net/2009/02\">"));
    }

    @Test
    public void shouldNotGenerateWADLWhenNotExplicitlyEnabledInConfig() throws IOException {
        this.server = CommunityServerBuilder.serverOnRandomPorts().usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get(this.server.baseUri().toString() + "application.wadl", MediaType.WILDCARD_TYPE);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldNotGenerateWADLWhenExplicitlyDisabledInConfig() throws IOException {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(ServerSettings.wadl_enabled.name(), "false").usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get(this.server.baseUri().toString() + "application.wadl", MediaType.WILDCARD_TYPE);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldEnableConsoleServiceByDefault() throws IOException {
        this.server = CommunityServerBuilder.serverOnRandomPorts().usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        Assert.assertEquals((long)200L, (long)new RestRequest().get(this.server.baseUri().toString() + "db/manage/server/console").getStatus());
    }

    @Test
    public void shouldDisableConsoleServiceWhenAskedTo() throws IOException {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(ServerSettings.console_module_enabled.name(), "false").usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        Assert.assertEquals((long)404L, (long)new RestRequest().get(this.server.baseUri().toString() + "db/manage/server/console").getStatus());
    }

    private HostnamePort getLocalHttpAddress() {
        ConnectorPortRegister connectorPortRegister = (ConnectorPortRegister)this.server.getDatabase().getGraph().getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
        return connectorPortRegister.getLocalAddress("http");
    }
}

