/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.discovery.CommunityDiscoverableURIs;
import org.neo4j.server.rest.discovery.DiscoveryService;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.test.server.EntityOutputFormat;

public class DiscoveryServiceTest {
    private String baseUri;
    private AdvertisedSocketAddress boltAddress;
    private URI dataUri;
    private URI managementUri;
    private final NeoServer neoServer = (NeoServer)Mockito.mock(NeoServer.class, (Answer)Answers.RETURNS_DEEP_STUBS);

    @Before
    public void setUp() throws URISyntaxException {
        this.baseUri = "http://www.example.com";
        this.boltAddress = new AdvertisedSocketAddress("www.example.com", 7687);
        this.dataUri = new URI("/data");
        this.managementUri = new URI("/management");
        ConnectorPortRegister portRegister = (ConnectorPortRegister)Mockito.mock(ConnectorPortRegister.class);
        Mockito.when((Object)portRegister.getLocalAddress("bolt")).thenReturn((Object)new HostnamePort("localhost", 7687));
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)this.neoServer.getDatabase().getGraph().getDependencyResolver()).thenReturn((Object)dependencyResolver);
        Mockito.when((Object)dependencyResolver.resolveDependency(ConnectorPortRegister.class)).thenReturn((Object)portRegister);
    }

    private Config mockConfig() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(GraphDatabaseSettings.auth_enabled.name(), "false");
        settings.put(new BoltConnector((String)"bolt").type.name(), "BOLT");
        settings.put(new BoltConnector((String)"bolt").enabled.name(), "true");
        settings.put(new BoltConnector((String)"bolt").advertised_address.name(), this.boltAddress.toString());
        settings.put(ServerSettings.management_api_path.name(), this.managementUri.toString());
        settings.put(ServerSettings.rest_api_path.name(), this.dataUri.toString());
        return Config.defaults(settings);
    }

    private DiscoveryService testDiscoveryService() throws URISyntaxException {
        return this.testDiscoveryService(this.mockConfig());
    }

    private DiscoveryService testDiscoveryService(Config config) throws URISyntaxException {
        return new DiscoveryService(config, (OutputFormat)new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI(this.baseUri), null), CommunityDiscoverableURIs.communityDiscoverableURIs((Config)config, null));
    }

    @Test
    public void shouldReturnValidJSON() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo("localhost"));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"\"\"")));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"null")));
    }

    private UriInfo uriInfo(String host) {
        URI uri = URI.create(host);
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getBaseUri()).thenReturn((Object)uri);
        return uriInfo;
    }

    @Test
    public void shouldReturnBoltURI() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo("localhost"));
        String json = new String((byte[])response.getEntity());
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"bolt\" : \"bolt://" + this.boltAddress)));
    }

    @Test
    public void shouldAllowOverridingBoltURI() throws Exception {
        Config config = this.mockConfig();
        config.augment(ServerSettings.bolt_discoverable_address, "bolt+routing://hello.com:7687");
        Response response = this.testDiscoveryService(config).getDiscoveryDocument(this.uriInfo("localhost"));
        String json = new String((byte[])response.getEntity());
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"bolt\" : \"bolt+routing://hello.com:7687"));
    }

    @Test
    public void shouldReturnDataURI() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo("localhost"));
        String json = new String((byte[])response.getEntity());
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"data\" : \"" + this.baseUri + this.dataUri + "/\"")));
    }

    @Test
    public void shouldReturnManagementURI() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo("localhost"));
        String json = new String((byte[])response.getEntity());
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"management\" : \"" + this.baseUri + this.managementUri + "/\"")));
    }

    @Test
    public void shouldReturnRedirectToAbsoluteAPIUsingOutputFormat() throws Exception {
        Config config = Config.defaults((Setting)ServerSettings.browser_path, (String)"/browser/");
        String baseUri = "http://www.example.com:5435";
        DiscoveryService ds = new DiscoveryService(config, (OutputFormat)new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI(baseUri), null), CommunityDiscoverableURIs.communityDiscoverableURIs((Config)config, null));
        Response response = ds.redirectToBrowser();
        Assert.assertThat((Object)response.getMetadata().getFirst((Object)"Location"), (Matcher)Matchers.is((Object)new URI("http://www.example.com:5435/browser/")));
    }
}

