/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import org.mockito.Mockito;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;

class TxStateCheckerTestSupport {
    static final TransitionalPeriodTransactionMessContainer TPTPMC = (TransitionalPeriodTransactionMessContainer)Mockito.mock(TransitionalPeriodTransactionMessContainer.class);
    private static FakeBridge fakeBridge = new FakeBridge();

    TxStateCheckerTestSupport() {
    }

    static {
        Mockito.when((Object)TPTPMC.getBridge()).thenReturn((Object)fakeBridge);
    }

    static class FakeBridge
    extends ThreadToStatementContextBridge {
        private final KernelTransaction tx = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        private final KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);

        FakeBridge() {
            super((AvailabilityGuard)Mockito.mock(AvailabilityGuard.class));
            Mockito.when((Object)this.tx.acquireStatement()).thenReturn((Object)this.statement);
            Mockito.when((Object)this.statement.hasTxStateWithChanges()).thenReturn((Object)false);
        }

        public KernelTransaction getKernelTransactionBoundToThisThread(boolean strict) {
            return this.tx;
        }
    }
}

