/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class Jetty9WebServerIT
extends ExclusiveServerTestBase {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private Jetty9WebServer webServer;

    @Test
    public void shouldBeAbleToUsePortZero() throws Exception {
        this.webServer = new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), Config.defaults(), NetworkConnectionTracker.NO_OP);
        this.webServer.setAddress(new ListenSocketAddress("localhost", 0));
        this.webServer.start();
    }

    @Test
    public void shouldBeAbleToRestart() throws Throwable {
        this.webServer = new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), Config.defaults(), NetworkConnectionTracker.NO_OP);
        this.webServer.setAddress(new ListenSocketAddress("127.0.0.1", 7878));
        this.webServer.start();
        this.webServer.stop();
        this.webServer.start();
    }

    @Test
    public void shouldStopCleanlyEvenWhenItHasntBeenStarted() {
        new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), Config.defaults(), NetworkConnectionTracker.NO_OP).stop();
    }

    @After
    public void cleanup() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
    }
}

