/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.server.web.JettyHttpConnection;

class JettyHttpConnectionTest {
    JettyHttpConnectionTest() {
    }

    @Test
    void shouldHaveId() {
        Connector connector = JettyHttpConnectionTest.connectorMock("https");
        JettyHttpConnection connection = JettyHttpConnectionTest.newConnection(connector);
        Assertions.assertEquals((Object)"http-1", (Object)connection.id());
    }

    @Test
    void shouldHaveConnectTime() {
        JettyHttpConnection connection = JettyHttpConnectionTest.newConnection(JettyHttpConnectionTest.connectorMock("http"));
        MatcherAssert.assertThat((Object)connection.connectTime(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    @Test
    void shouldHaveConnector() {
        JettyHttpConnection connection = JettyHttpConnectionTest.newConnection(JettyHttpConnectionTest.connectorMock("http+routing"));
        Assertions.assertEquals((Object)"http+routing", (Object)connection.connector());
    }

    @Test
    void shouldHaveUser() {
        JettyHttpConnection connection = JettyHttpConnectionTest.newConnection(JettyHttpConnectionTest.connectorMock("http+routing"));
        Assertions.assertNull((Object)connection.user());
        connection.updateUser("hello");
        Assertions.assertEquals((Object)"hello", (Object)connection.user());
    }

    private static JettyHttpConnection newConnection(Connector connector) {
        return new JettyHttpConnection("http-1", new HttpConfiguration(), connector, (EndPoint)Mockito.mock(EndPoint.class), HttpCompliance.LEGACY, false);
    }

    private static Connector connectorMock(String name) {
        Connector connector = (Connector)Mockito.mock(Connector.class);
        Mockito.when((Object)connector.getName()).thenReturn((Object)name);
        Mockito.when((Object)connector.getExecutor()).thenReturn(Runnable::run);
        Mockito.when((Object)connector.getServer()).thenReturn((Object)new Server());
        return connector;
    }
}

