/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.discovery.CommunityDiscoverableURIs;
import org.neo4j.server.rest.discovery.DiscoverableURIs;

public class CommunityDiscoverableURIsTest {
    @Test
    public void shouldAdvertiseDataAndManagementURIs() throws Exception {
        DiscoverableURIs uris = CommunityDiscoverableURIs.communityDiscoverableURIs((Config)Config.defaults(), null);
        Assert.assertEquals((Object)MapUtil.map((Object[])new Object[]{"data", "/db/data/", "management", "/db/manage/"}), this.toMap(uris));
    }

    @Test
    public void shouldAdvertiseBoltIfExplicitlyConfigured() throws Exception {
        DiscoverableURIs uris = CommunityDiscoverableURIs.communityDiscoverableURIs((Config)Config.defaults((Setting)ServerSettings.bolt_discoverable_address, (String)"bolt://banana.com:1234"), null);
        Assert.assertEquals((Object)"bolt://banana.com:1234", (Object)this.toMap(uris).get("bolt"));
    }

    @Test
    public void shouldLookupBoltPortInRegisterIfConfiguredTo0() throws Exception {
        BoltConnector bolt = new BoltConnector("honestJakesBoltConnector");
        ConnectorPortRegister register = new ConnectorPortRegister();
        register.register(bolt.key(), new InetSocketAddress(1337));
        DiscoverableURIs uris = CommunityDiscoverableURIs.communityDiscoverableURIs((Config)Config.builder().withSetting(bolt.advertised_address, "apple.com:0").withSetting(bolt.enabled, "true").withSetting(bolt.type, Connector.ConnectorType.BOLT.name()).build(), (ConnectorPortRegister)register);
        Assert.assertEquals((Object)"bolt://apple.com:1337", (Object)this.toMap(uris).get("bolt"));
    }

    @Test
    public void shouldOmitBoltIfNoConnectorConfigured() throws Exception {
        DiscoverableURIs uris = CommunityDiscoverableURIs.communityDiscoverableURIs((Config)Config.builder().build(), null);
        Assert.assertFalse((boolean)this.toMap(uris).containsKey("bolt"));
    }

    private Map<String, Object> toMap(DiscoverableURIs uris) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        uris.forEachAbsoluteUri((k, v) -> out.put((String)k, v.toASCIIString()));
        uris.forEachRelativeUri(out::put);
        return out;
    }
}

