/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class AuthorizationRepresentation
extends ObjectRepresentation {
    private final User user;

    public AuthorizationRepresentation(User user) {
        super(RepresentationType.AUTHORIZATION);
        this.user = user;
    }

    @ObjectRepresentation.Mapping(value="username")
    public ValueRepresentation user() {
        return ValueRepresentation.string((String)this.user.name());
    }

    @ObjectRepresentation.Mapping(value="password_change_required")
    public ValueRepresentation passwordChangeRequired() {
        return ValueRepresentation.bool((boolean)this.user.passwordChangeRequired());
    }

    @ObjectRepresentation.Mapping(value="password_change")
    public ValueRepresentation passwordChange() {
        return ValueRepresentation.uri((String)String.format("/user/%s/password", this.user.name()));
    }
}

