/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConnectorPortRegister;

public class DiscoverableURIs {
    private final Collection<Pair<String, String>> relativeUris = new ArrayList<Pair<String, String>>();
    private final Collection<Pair<String, URI>> absoluteUris = new ArrayList<Pair<String, URI>>();

    public DiscoverableURIs addRelative(String key, String uri) {
        this.relativeUris.add((Pair<String, String>)Pair.pair((Object)key, (Object)uri));
        return this;
    }

    public DiscoverableURIs addAbsolute(String key, URI uri) {
        this.absoluteUris.add((Pair<String, URI>)Pair.pair((Object)key, (Object)uri));
        return this;
    }

    public static Optional<URI> discoverableBoltUri(String scheme, Config config, Setting<URI> override, ConnectorPortRegister connectorPortRegister) {
        if (config.isConfigured(override)) {
            return Optional.ofNullable(config.get(override));
        }
        return config.enabledBoltConnectors().stream().findFirst().map(c -> {
            AdvertisedSocketAddress advertisedSocketAddress = (AdvertisedSocketAddress)config.get(c.advertised_address);
            if (advertisedSocketAddress.getPort() == 0) {
                int boltPort = connectorPortRegister.getLocalAddress(c.key()).getPort();
                return DiscoverableURIs.boltURI(scheme, advertisedSocketAddress.getHostname(), boltPort);
            }
            return DiscoverableURIs.boltURI(scheme, advertisedSocketAddress.getHostname(), advertisedSocketAddress.getPort());
        });
    }

    public void forEachRelativeUri(BiConsumer<String, String> consumer) {
        this.relativeUris.forEach(p -> consumer.accept((String)p.first(), (String)p.other()));
    }

    public void forEachAbsoluteUri(BiConsumer<String, URI> consumer) {
        this.absoluteUris.forEach(p -> consumer.accept((String)p.first(), (URI)p.other()));
    }

    private static URI boltURI(String scheme, String host, int port) {
        try {
            return new URI(scheme, null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new InvalidSettingException(String.format("Unable to construct bolt discoverable URI using '%s' as hostname: %s", host, e.getMessage()), (Throwable)e);
        }
    }
}

