/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.modules.DBMSModule;
import org.neo4j.server.rest.dbms.UserService;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.web.WebServer;
import org.neo4j.test.rule.SuppressOutput;

public class DBMSModuleTest {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppress((SuppressOutput.Suppressible[])new SuppressOutput.Suppressible[]{SuppressOutput.System.err, SuppressOutput.System.out});

    @Test
    public void shouldRegisterAtRootByDefault() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        Config config = (Config)Mockito.mock(Config.class);
        CommunityNeoServer neoServer = (CommunityNeoServer)Mockito.mock(CommunityNeoServer.class);
        Mockito.when((Object)neoServer.baseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        Mockito.when((Object)config.get(GraphDatabaseSettings.auth_enabled)).thenReturn((Object)true);
        DBMSModule module = new DBMSModule(webServer, config, DiscoverableURIs::new);
        module.start();
        ((WebServer)Mockito.verify((Object)webServer)).addJAXRSClasses(ArgumentMatchers.anyList(), ArgumentMatchers.anyString(), (Collection)ArgumentMatchers.isNull());
    }

    @Test
    public void shouldNotRegisterUserServiceWhenAuthDisabled() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        Config config = (Config)Mockito.mock(Config.class);
        CommunityNeoServer neoServer = (CommunityNeoServer)Mockito.mock(CommunityNeoServer.class);
        Mockito.when((Object)neoServer.baseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        Mockito.when((Object)config.get(GraphDatabaseSettings.auth_enabled)).thenReturn((Object)false);
        DBMSModule module = new DBMSModule(webServer, config, DiscoverableURIs::new);
        module.start();
        ((WebServer)Mockito.verify((Object)webServer)).addJAXRSClasses(ArgumentMatchers.anyList(), ArgumentMatchers.anyString(), (Collection)ArgumentMatchers.isNull());
        ((WebServer)Mockito.verify((Object)webServer, (VerificationMode)Mockito.never())).addJAXRSClasses((List)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<List<String>>(){

            public boolean matches(List<String> argument) {
                return argument.contains(UserService.class.getName());
            }

            public String toString() {
                return "<List containing " + UserService.class.getName() + ">";
            }
        }), ArgumentMatchers.anyString(), ArgumentMatchers.anyCollection());
    }
}

