/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.ServerBootstrapper;
import org.neo4j.server.database.CommunityGraphFactory;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.web.WebServer;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class ServerUserLogTest {
    @Rule
    public final SuppressOutput suppress = SuppressOutput.suppress((SuppressOutput.Suppressible[])new SuppressOutput.Suppressible[]{SuppressOutput.System.out});
    @Rule
    public TestDirectory homeDir = TestDirectory.testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLogToStdOutByDefault() {
        ServerBootstrapper serverBootstrapper = this.getServerBootstrapper();
        File dir = this.homeDir.directory();
        Log logBeforeStart = serverBootstrapper.getLog();
        try {
            int returnCode = serverBootstrapper.start(dir, Optional.empty(), MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.database_path.name(), this.homeDir.absolutePath().getAbsolutePath()}));
            Assert.assertEquals((long)0L, (long)returnCode);
            Assert.assertTrue((boolean)serverBootstrapper.getServer().getDatabase().isRunning());
            Assert.assertThat((Object)serverBootstrapper.getLog(), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)logBeforeStart)));
            Assert.assertThat(this.getStdOut(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
            Assert.assertThat(this.getStdOut(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Started.")));
        }
        finally {
            serverBootstrapper.stop();
        }
        Assert.assertFalse((boolean)Files.exists(this.getUserLogFileLocation(dir), new LinkOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLogToFileWhenConfigured() throws Exception {
        ServerBootstrapper serverBootstrapper = this.getServerBootstrapper();
        File dir = this.homeDir.directory();
        Log logBeforeStart = serverBootstrapper.getLog();
        try {
            int returnCode = serverBootstrapper.start(dir, Optional.empty(), MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.database_path.name(), this.homeDir.absolutePath().getAbsolutePath(), GraphDatabaseSettings.store_user_log_to_stdout.name(), "false"}));
            Assert.assertEquals((long)0L, (long)returnCode);
            Assert.assertTrue((boolean)serverBootstrapper.getServer().getDatabase().isRunning());
            Assert.assertThat((Object)serverBootstrapper.getLog(), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)logBeforeStart)));
        }
        finally {
            serverBootstrapper.stop();
        }
        Assert.assertThat(this.getStdOut(), (Matcher)Matchers.empty());
        Assert.assertTrue((boolean)Files.exists(this.getUserLogFileLocation(dir), new LinkOption[0]));
        Assert.assertThat(this.readUserLogFile(dir), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Assert.assertThat(this.readUserLogFile(dir), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Started.")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void logShouldRotateWhenConfigured() throws Exception {
        ServerBootstrapper serverBootstrapper = this.getServerBootstrapper();
        File dir = this.homeDir.directory();
        Log logBeforeStart = serverBootstrapper.getLog();
        int maxArchives = 4;
        try {
            int returnCode = serverBootstrapper.start(dir, Optional.empty(), MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.database_path.name(), this.homeDir.absolutePath().getAbsolutePath(), GraphDatabaseSettings.store_user_log_to_stdout.name(), "false", GraphDatabaseSettings.store_user_log_rotation_delay.name(), "0", GraphDatabaseSettings.store_user_log_rotation_threshold.name(), "16", GraphDatabaseSettings.store_user_log_max_archives.name(), Integer.toString(maxArchives)}));
            Assert.assertEquals((long)0L, (long)returnCode);
            Assert.assertThat((Object)serverBootstrapper.getLog(), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)logBeforeStart)));
            Assert.assertTrue((boolean)serverBootstrapper.getServer().getDatabase().isRunning());
            do {
                serverBootstrapper.getLog().info("testing 123. This string should contain more than 16 bytes\n");
                Thread.sleep(2000L);
            } while (this.allUserLogFiles(dir).size() <= 4);
        }
        finally {
            serverBootstrapper.stop();
        }
        Assert.assertThat(this.getStdOut(), (Matcher)Matchers.empty());
        Assert.assertTrue((boolean)Files.exists(this.getUserLogFileLocation(dir), new LinkOption[0]));
        Assert.assertThat(this.readUserLogFile(dir), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        List<String> userLogFiles = this.allUserLogFiles(dir);
        Assert.assertThat(userLogFiles, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"neo4j.log", "neo4j.log.1", "neo4j.log.2", "neo4j.log.3", "neo4j.log.4"}));
        Assert.assertEquals((long)(maxArchives + 1), (long)userLogFiles.size());
    }

    private List<String> getStdOut() {
        List lines = this.suppress.getOutputVoice().lines();
        return lines.stream().filter(line -> !line.equals("")).collect(Collectors.toList());
    }

    private ServerBootstrapper getServerBootstrapper() {
        return new ServerBootstrapper(){

            protected GraphFactory createGraphFactory(Config config) {
                return new CommunityGraphFactory();
            }

            protected NeoServer createNeoServer(GraphFactory graphFactory, Config config, GraphDatabaseDependencies dependencies) {
                dependencies.userLogProvider();
                return new AbstractNeoServer(config, graphFactory, (GraphDatabaseFacadeFactory.Dependencies)dependencies){

                    protected Iterable<ServerModule> createServerModules() {
                        return new ArrayList<ServerModule>(0);
                    }

                    protected void configureWebServer() {
                    }

                    protected void startWebServer() {
                    }

                    protected WebServer createWebServer() {
                        return null;
                    }

                    public Iterable<AdvertisableService> getServices() {
                        return new ArrayList<AdvertisableService>(0);
                    }
                };
            }
        };
    }

    private List<String> readUserLogFile(File homeDir) throws IOException {
        return Files.readAllLines(this.getUserLogFileLocation(homeDir)).stream().filter(line -> !line.equals("")).collect(Collectors.toList());
    }

    private Path getUserLogFileLocation(File homeDir) {
        return Paths.get(homeDir.getAbsolutePath(), "logs", "neo4j.log");
    }

    private List<String> allUserLogFiles(File homeDir) throws IOException {
        try (Stream<String> stream = Files.list(Paths.get(homeDir.getAbsolutePath(), "logs")).map(x -> x.getFileName().toString()).filter(x -> x.contains("neo4j.log"));){
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }
}

