/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.integration;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.database.Database;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class SnapshotQueryExecutionIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;

    @Before
    public void setUp() throws Exception {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.snapshot_query.name(), "true").build();
        this.server.start();
    }

    @After
    public void tearDown() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void executeQueryWithSnapshotEngine() {
        Database database = this.server.getDatabase();
        GraphDatabaseFacade graph = database.getGraph();
        try (Transaction transaction = graph.beginTx();){
            for (int i = 0; i < 10; ++i) {
                Node node = graph.createNode();
                node.setProperty("a", (Object)"b");
            }
            transaction.success();
        }
        HTTP.Builder httpClientBuilder = HTTP.withBaseUri(this.server.baseUri());
        HTTP.Response transactionStart = httpClientBuilder.POST(this.transactionURI());
        MatcherAssert.assertThat((Object)transactionStart.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        HTTP.Response response = httpClientBuilder.POST(transactionStart.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'MATCH (n) RETURN n' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    private String transactionURI() {
        return "db/data/transaction";
    }
}

