/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.transactional.DeserializationException;
import org.neo4j.server.rest.transactional.Statement;
import org.neo4j.server.rest.transactional.StatementDeserializer;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.string.UTF8;

public class StatementDeserializerTest {
    @Test
    public void shouldDeserializeSingleStatement() {
        String json = JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"statements", Arrays.asList(MapUtil.map((Object[])new Object[]{"statement", "Blah blah", "parameters", MapUtil.map((Object[])new Object[]{"one", 12})}))}));
        StatementDeserializer de = new StatementDeserializer((InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)true));
        Statement stmt = (Statement)de.next();
        MatcherAssert.assertThat((Object)stmt.statement(), (Matcher)Matchers.equalTo((Object)"Blah blah"));
        MatcherAssert.assertThat((Object)stmt.parameters(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"one", 12})));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldRejectMapWithADifferentFieldBeforeStatement() {
        String json = "{ \"timeout\" : 200, \"statements\" : [ { \"statement\" : \"ignored\", \"parameters\" : {}} ] }";
        this.assertYieldsErrors(json, new Neo4jError((Status)Status.Request.InvalidFormat, (Throwable)new DeserializationException("Unable to deserialize request. Expected first field to be 'statements', but was 'timeout'.")));
    }

    @Test
    public void shouldTotallyIgnoreInvalidJsonAfterStatementArrayHasFinished() {
        String json = "{ \"statements\" : [ { \"statement\" : \"Blah blah\", \"parameters\" : {\"one\" : 12}} ] totally invalid json is totally ignored";
        StatementDeserializer de = new StatementDeserializer((InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)true));
        Statement stmt = (Statement)de.next();
        MatcherAssert.assertThat((Object)stmt.statement(), (Matcher)Matchers.equalTo((Object)"Blah blah"));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldIgnoreUnknownFields() {
        String json = "{ \"statements\" : [ { \"a\" : \"\", \"b\" : { \"k\":1 }, \"statement\" : \"blah\" } ] }";
        StatementDeserializer de = new StatementDeserializer((InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((Statement)de.next()).statement(), (Matcher)Matchers.equalTo((Object)"blah"));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldTakeParametersBeforeStatement() {
        String json = "{ \"statements\" : [ { \"a\" : \"\", \"parameters\" : { \"k\":1 }, \"statement\" : \"blah\"}]}";
        StatementDeserializer de = new StatementDeserializer((InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)true));
        Statement stmt = (Statement)de.next();
        MatcherAssert.assertThat((Object)stmt.statement(), (Matcher)Matchers.equalTo((Object)"blah"));
        MatcherAssert.assertThat((Object)stmt.parameters(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"k", 1})));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldTreatEmptyInputStreamAsEmptyStatementList() {
        byte[] json = new byte[]{};
        StatementDeserializer de = new StatementDeserializer((InputStream)new ByteArrayInputStream(json));
        Assert.assertFalse((boolean)de.hasNext());
        Assert.assertFalse((boolean)de.errors().hasNext());
    }

    @Test
    public void shouldDeserializeMultipleStatements() {
        String json = JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"statements", Arrays.asList(MapUtil.map((Object[])new Object[]{"statement", "Blah blah", "parameters", MapUtil.map((Object[])new Object[]{"one", 12})}), MapUtil.map((Object[])new Object[]{"statement", "Blah bluh", "parameters", MapUtil.map((Object[])new Object[]{"asd", Arrays.asList("one, two")})}))}));
        StatementDeserializer de = new StatementDeserializer((InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)true));
        Statement stmt = (Statement)de.next();
        MatcherAssert.assertThat((Object)stmt.statement(), (Matcher)Matchers.equalTo((Object)"Blah blah"));
        MatcherAssert.assertThat((Object)stmt.parameters(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"one", 12})));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)true));
        Statement stmt2 = (Statement)de.next();
        MatcherAssert.assertThat((Object)stmt2.statement(), (Matcher)Matchers.equalTo((Object)"Blah bluh"));
        MatcherAssert.assertThat((Object)stmt2.parameters(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"asd", Arrays.asList("one, two")})));
        MatcherAssert.assertThat((Object)de.hasNext(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotThrowButReportErrorOnInvalidInput() {
        this.assertYieldsErrors("{}", new Neo4jError((Status)Status.Request.InvalidFormat, (Throwable)new DeserializationException("Unable to deserialize request. Expected [START_OBJECT, FIELD_NAME, START_ARRAY], found [START_OBJECT, END_OBJECT, null].")));
        this.assertYieldsErrors("{ \"statements\":\"WAIT WAT A STRING NOO11!\" }", new Neo4jError((Status)Status.Request.InvalidFormat, (Throwable)new DeserializationException("Unable to deserialize request. Expected [START_OBJECT, FIELD_NAME, START_ARRAY], found [START_OBJECT, FIELD_NAME, VALUE_STRING].")));
        this.assertYieldsErrors("[{]}", new Neo4jError((Status)Status.Request.InvalidFormat, (Throwable)new DeserializationException("Unable to deserialize request: Unexpected close marker ']': expected '}' (for Object starting at [Source: (ByteArrayInputStream); line: 1, column: 2])\n at [Source: (ByteArrayInputStream); line: 1, column: 4]")));
        this.assertYieldsErrors("{ \"statements\" : \"ITS A STRING\" }", new Neo4jError((Status)Status.Request.InvalidFormat, (Throwable)new DeserializationException("Unable to deserialize request. Expected [START_OBJECT, FIELD_NAME, START_ARRAY], found [START_OBJECT, FIELD_NAME, VALUE_STRING].")));
        this.assertYieldsErrors("{ \"statements\" : [ { \"statement\" : [\"dd\"] } ] }", new Neo4jError((Status)Status.Request.InvalidFormat, (Throwable)new DeserializationException("Unable to deserialize request: Cannot deserialize instance of `java.lang.String` out of START_ARRAY token\n at [Source: (ByteArrayInputStream); line: 1, column: 36]")));
        this.assertYieldsErrors("{ \"statements\" : [ { \"statement\" : \"stmt\", \"parameters\" : [\"AN ARRAY!!\"] } ] }", new Neo4jError((Status)Status.Request.InvalidFormat, (Throwable)new DeserializationException("Unable to deserialize request: Cannot deserialize instance of `java.util.LinkedHashMap<java.lang.Object,java.lang.Object>` out of START_ARRAY token\n at [Source: (ByteArrayInputStream); line: 1, column: 59]")));
    }

    private void assertYieldsErrors(String json, Neo4jError ... expectedErrors) {
        StatementDeserializer de = new StatementDeserializer((InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        while (de.hasNext()) {
            de.next();
        }
        Iterator actual = de.errors();
        Iterator<Neo4jError> expected = Arrays.asList(expectedErrors).iterator();
        while (actual.hasNext()) {
            Assert.assertTrue((boolean)expected.hasNext());
            Neo4jError error = (Neo4jError)actual.next();
            Neo4jError expectedError = expected.next();
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.equalTo((Object)expectedError.getMessage()));
            MatcherAssert.assertThat((Object)error.status(), (Matcher)Matchers.equalTo((Object)expectedError.status()));
        }
        Assert.assertFalse((boolean)expected.hasNext());
    }
}

