/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.function.Function;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.IndexPopulationProgress;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class IndexDefinitionRepresentation
extends MappingRepresentation {
    private final IndexDefinition indexDefinition;
    private final IndexPopulationProgress indexPopulationProgress;
    private final Schema.IndexState indexState;

    public IndexDefinitionRepresentation(IndexDefinition indexDefinition) {
        this(indexDefinition, Schema.IndexState.ONLINE, IndexPopulationProgress.DONE);
    }

    public IndexDefinitionRepresentation(IndexDefinition indexDefinition, Schema.IndexState indexState, IndexPopulationProgress indexPopulationProgress) {
        super(RepresentationType.INDEX_DEFINITION);
        this.indexDefinition = indexDefinition;
        this.indexPopulationProgress = indexPopulationProgress;
        this.indexState = indexState;
    }

    protected void serialize(MappingSerializer serializer) {
        if (this.indexDefinition.isNodeIndex()) {
            serializer.putList("labels", new ListRepresentation(RepresentationType.STRING, Iterables.map(label -> ValueRepresentation.string((String)label.name()), (Iterable)this.indexDefinition.getLabels())));
            if (!this.indexDefinition.isMultiTokenIndex()) {
                serializer.putString("label", ((Label)Iterables.single((Iterable)this.indexDefinition.getLabels())).name());
            }
        } else {
            serializer.putList("relationshipTypes", new ListRepresentation(RepresentationType.STRING, Iterables.map(relType -> ValueRepresentation.string((String)relType.name()), (Iterable)this.indexDefinition.getRelationshipTypes())));
            if (!this.indexDefinition.isMultiTokenIndex()) {
                serializer.putString("relationshipType", ((RelationshipType)Iterables.single((Iterable)this.indexDefinition.getRelationshipTypes())).name());
            }
        }
        Function<String, Representation> converter = ValueRepresentation::string;
        Iterable propertyKeyRepresentations = Iterables.map(converter, (Iterable)this.indexDefinition.getPropertyKeys());
        serializer.putList("property_keys", new ListRepresentation(RepresentationType.STRING, propertyKeyRepresentations));
        if (this.indexState == Schema.IndexState.POPULATING) {
            serializer.putString("state", this.indexState.name());
            serializer.putString("population_progress", String.format("%1.0f%%", Float.valueOf(this.indexPopulationProgress.getCompletedPercentage())));
        }
    }
}

