/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.rest.dbms.UserService;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.rest.discovery.DiscoveryService;
import org.neo4j.server.web.WebServer;

public class DBMSModule
implements ServerModule {
    private static final String ROOT_PATH = "/";
    private final WebServer webServer;
    private final Config config;
    private final Supplier<DiscoverableURIs> discoverableURIs;

    public DBMSModule(WebServer webServer, Config config, Supplier<DiscoverableURIs> discoverableURIs) {
        this.webServer = webServer;
        this.config = config;
        this.discoverableURIs = discoverableURIs;
    }

    @Override
    public void start() {
        this.webServer.addJAXRSClasses(Collections.singletonList(DiscoveryService.class.getName()), ROOT_PATH, Collections.singletonList(Injectable.injectable(DiscoverableURIs.class, (Object)this.discoverableURIs.get())));
        this.webServer.addJAXRSClasses(this.getClassNames(), ROOT_PATH, null);
    }

    private List<String> getClassNames() {
        ArrayList<String> toReturn = new ArrayList<String>(2);
        if (((Boolean)this.config.get(GraphDatabaseSettings.auth_enabled)).booleanValue()) {
            toReturn.add(UserService.class.getName());
        }
        return toReturn;
    }

    @Override
    public void stop() {
        this.webServer.removeJAXRSClasses(this.getClassNames(), ROOT_PATH);
    }
}

