/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class ReadOnlyIT
extends ExclusiveServerTestBase {
    @Rule
    public TestDirectory dir = TestDirectory.testDirectory();
    private NeoServer readOnlyServer;
    private HTTP.Builder http;

    @Before
    public void setup() throws IOException {
        ServerHelper.cleanTheDatabase(this.readOnlyServer);
        this.readOnlyServer = ServerHelper.createReadOnlyServer(this.dir.storeDir());
        this.http = HTTP.withBaseUri(this.readOnlyServer.baseUri());
    }

    @After
    public void teardown() {
        if (this.readOnlyServer != null) {
            this.readOnlyServer.stop();
        }
    }

    @Test
    public void shouldReturnReadOnlyStatusWhenCreatingNodes() throws Exception {
        HTTP.Response response = this.http.POST("db/data/transaction/commit", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (node)' } ] }"));
        JsonNode error = response.get("errors").get(0);
        String code = error.get("code").asText();
        String message = error.get("message").asText();
        Assert.assertEquals((Object)"Neo.ClientError.General.ForbiddenOnReadOnlyDatabase", (Object)code);
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"This is a read only Neo4j instance"));
    }

    @Test
    public void shouldReturnReadOnlyStatusWhenCreatingNodesWhichTransitivelyCreateTokens() throws Exception {
        HTTP.Response response = this.http.POST("db/data/transaction/commit", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (node:Node)' } ] }"));
        JsonNode error = response.get("errors").get(0);
        String code = error.get("code").asText();
        String message = error.get("message").asText();
        Assert.assertEquals((Object)"Neo.ClientError.General.ForbiddenOnReadOnlyDatabase", (Object)code);
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"This is a read only Neo4j instance"));
    }
}

