/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.management.console;

import javax.servlet.http.HttpServletRequest;
import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.rest.management.console.ScriptSession;
import org.neo4j.values.virtual.VirtualValues;

public class CypherSession
implements ScriptSession {
    private final CypherExecutor cypherExecutor;
    private final Log log;
    private final HttpServletRequest request;

    public CypherSession(CypherExecutor cypherExecutor, LogProvider logProvider, HttpServletRequest request) {
        this.cypherExecutor = cypherExecutor;
        this.log = logProvider.getLog(this.getClass());
        this.request = request;
    }

    @Override
    public Pair<String, String> evaluate(String script) {
        String resultString;
        if ("".equals(script.trim())) {
            return Pair.of((Object)"", null);
        }
        try {
            TransactionalContext tc = this.cypherExecutor.createTransactionContext(script, VirtualValues.emptyMap(), this.request);
            ExecutionEngine engine = this.cypherExecutor.getExecutionEngine();
            Result result = engine.executeQuery(script, VirtualValues.emptyMap(), tc);
            resultString = result.resultAsString();
        }
        catch (SyntaxException error) {
            resultString = error.getMessage();
        }
        catch (Exception exception) {
            this.log.error("Unknown error executing cypher query", (Throwable)exception);
            resultString = "Error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage();
        }
        return Pair.of((Object)resultString, null);
    }
}

