/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.net.URI;
import java.net.URISyntaxException;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class SimpleUriBuilder {
    public URI buildURI(AdvertisedSocketAddress address, boolean isSsl) {
        String scheme = "http";
        if (isSsl) {
            scheme = scheme + "s";
        }
        try {
            int port = address.getPort();
            if (!isSsl && port == 80 || isSsl && port == 443) {
                return new URI(scheme, address.getHostname(), "/", null);
            }
            return new URI(scheme, null, address.getHostname(), port, "/", null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

