/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.net.URI;
import java.net.URISyntaxException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.server.web.SimpleUriBuilder;

class SimpleUriBuilderTest {
    SimpleUriBuilderTest() {
    }

    @Test
    void shouldIncludeScheme() {
        SimpleUriBuilder builder = new SimpleUriBuilder();
        URI uri1 = builder.buildURI(new AdvertisedSocketAddress("neo4j.example.org", 443), false);
        URI uri2 = builder.buildURI(new AdvertisedSocketAddress("neo4j.example.org", 80), true);
        Assertions.assertEquals((Object)"http", (Object)uri1.getScheme());
        Assertions.assertEquals((Object)"https", (Object)uri2.getScheme());
    }

    @Test
    void shouldIncludePortWhenNecessary() {
        SimpleUriBuilder builder = new SimpleUriBuilder();
        URI uri1 = builder.buildURI(new AdvertisedSocketAddress("neo4j.example.org", 80), false);
        URI uri2 = builder.buildURI(new AdvertisedSocketAddress("neo4j.example.org", 443), true);
        URI uri3 = builder.buildURI(new AdvertisedSocketAddress("neo4j.example.org", 443), false);
        URI uri4 = builder.buildURI(new AdvertisedSocketAddress("neo4j.example.org", 80), true);
        URI uri5 = builder.buildURI(new AdvertisedSocketAddress("neo4j.example.org", 7690), false);
        Assertions.assertEquals((int)-1, (int)uri1.getPort());
        Assertions.assertEquals((int)-1, (int)uri2.getPort());
        Assertions.assertEquals((int)443, (int)uri3.getPort());
        Assertions.assertEquals((int)80, (int)uri4.getPort());
        Assertions.assertEquals((int)7690, (int)uri5.getPort());
    }

    @Test
    void shouldRejectInvalidHostnames() {
        SimpleUriBuilder builder = new SimpleUriBuilder();
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> builder.buildURI(new AdvertisedSocketAddress("$core_1", 443), false));
        Throwable cause = ex.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof URISyntaxException));
    }
}

