/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.cypher.internal.javacompat.MapRow;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.transactional.Neo4jJsonCodec;
import org.neo4j.server.rest.transactional.RestRepresentationWriter;
import org.neo4j.server.rest.transactional.ResultDataContentWriter;

public class RestRepresentationWriterTest {
    @Test
    public void shouldWriteNestedMaps() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator json = new JsonFactory((ObjectCodec)new Neo4jJsonCodec()).createJsonGenerator((OutputStream)out);
        JsonNode rest = this.serialize(out, json, (ResultDataContentWriter)new RestRepresentationWriter(URI.create("localhost")));
        MatcherAssert.assertThat((Object)rest.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        JsonNode firstCell = rest.get(0);
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").get(0).asBoolean(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").get(1).get("three").asInt(), (Matcher)CoreMatchers.is((Object)42));
    }

    private JsonNode serialize(ByteArrayOutputStream out, JsonGenerator json, ResultDataContentWriter resultDataContentWriter) throws IOException, JsonParseException {
        json.writeStartObject();
        resultDataContentWriter.write(json, Arrays.asList("the column"), (Result.ResultRow)new MapRow(MapUtil.map((Object[])new Object[]{"the column", MapUtil.map((Object[])new Object[]{"one", MapUtil.map((Object[])new Object[]{"two", Arrays.asList(true, MapUtil.map((Object[])new Object[]{"three", 42}))})})})), null);
        json.writeEndObject();
        json.flush();
        json.close();
        String jsonAsString = out.toString();
        return JsonHelper.jsonNode((String)jsonAsString).get("rest");
    }
}

