/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.error.InvalidTransactionId;
import org.neo4j.server.rest.transactional.error.TransactionLifecycleException;

public interface TransactionRegistry {
    public long begin(TransactionHandle var1);

    public long release(long var1, TransactionHandle var3);

    public TransactionHandle acquire(long var1) throws TransactionLifecycleException;

    public void forget(long var1);

    public TransactionHandle terminate(long var1) throws TransactionLifecycleException;

    public void rollbackAllSuspendedTransactions();

    default public TransactionHandle acquire(long id, LoginContext requestingUser) throws TransactionLifecycleException {
        this.assertSameUser(this.getLoginContextForTransaction(id), requestingUser);
        return this.acquire(id);
    }

    default public TransactionHandle terminate(long id, LoginContext requestingUser) throws TransactionLifecycleException {
        this.assertSameUser(this.getLoginContextForTransaction(id), requestingUser);
        return this.terminate(id);
    }

    default public void assertSameUser(LoginContext owningUser, LoginContext requestingUser) throws InvalidTransactionId {
        if (!owningUser.subject().username().equals(requestingUser.subject().username())) {
            throw new InvalidTransactionId();
        }
    }

    public LoginContext getLoginContextForTransaction(long var1) throws InvalidTransactionId;
}

