/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.BiConsumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.server.rest.discovery.DiscoverableURIs;

public class DiscoverableURIsTest {
    private BiConsumer<String, URI> consumer = (BiConsumer)Mockito.mock(BiConsumer.class);

    @Test
    public void shouldNotInvokeConsumerWhenEmpty() {
        DiscoverableURIs empty = new DiscoverableURIs.Builder().build();
        empty.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.never())).accept(ArgumentMatchers.anyString(), ArgumentMatchers.any());
    }

    @Test
    public void shouldInvokeConsumerForEachKey() throws URISyntaxException {
        DiscoverableURIs discoverables = new DiscoverableURIs.Builder().add("a", "/test", DiscoverableURIs.Precedence.NORMAL).add("b", "/data", DiscoverableURIs.Precedence.NORMAL).add("c", "http://www.example.com", DiscoverableURIs.Precedence.LOW).build();
        discoverables.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("a", new URI("/test"));
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("b", new URI("/data"));
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("c", new URI("http://www.example.com"));
    }

    @Test
    public void shouldThrowWhenAddingTwoEntriesWithSamePrecedence() {
        try {
            DiscoverableURIs discoverables = new DiscoverableURIs.Builder().add("a", "/test", DiscoverableURIs.Precedence.NORMAL).add("a", "/data", DiscoverableURIs.Precedence.NORMAL).build();
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(InvalidSettingException.class)));
            Assert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Unable to add two entries with the same precedence using key "));
        }
    }

    @Test
    public void shouldInvokeConsumerForEachKeyWithHighestPrecedence() throws URISyntaxException {
        DiscoverableURIs discoverables = new DiscoverableURIs.Builder().add("c", "bolt://localhost:7687", DiscoverableURIs.Precedence.HIGHEST).add("a", "/test", DiscoverableURIs.Precedence.NORMAL).add("b", "/data", DiscoverableURIs.Precedence.NORMAL).add("b", "/data2", DiscoverableURIs.Precedence.LOWEST).add("a", "/test2", DiscoverableURIs.Precedence.HIGHEST).add("c", "bolt://localhost:7688", DiscoverableURIs.Precedence.LOW).build();
        discoverables.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("a", new URI("/test2"));
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("b", new URI("/data"));
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("c", new URI("bolt://localhost:7687"));
    }

    @Test
    public void shouldInvokeConsumerForEachKeyWithHighestPrecedenceOnce() throws URISyntaxException {
        DiscoverableURIs discoverables = new DiscoverableURIs.Builder().add("a", "/test1", DiscoverableURIs.Precedence.LOWEST).add("a", "/test2", DiscoverableURIs.Precedence.LOW).add("a", "/data3", DiscoverableURIs.Precedence.NORMAL).add("a", "/test4", DiscoverableURIs.Precedence.HIGH).add("a", "/test5", DiscoverableURIs.Precedence.HIGHEST).build();
        discoverables.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.only())).accept("a", new URI("/test5"));
    }

    @Test
    public void shouldConvertStringIntoURI() throws URISyntaxException {
        DiscoverableURIs empty = new DiscoverableURIs.Builder().add("a", "bolt://localhost:7687", DiscoverableURIs.Precedence.NORMAL).build();
        empty.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("a", new URI("bolt://localhost:7687"));
    }

    @Test
    public void shouldConvertSchemeHostPortIntoURI() throws URISyntaxException {
        DiscoverableURIs empty = new DiscoverableURIs.Builder().add("a", "bolt", "www.example.com", 8888, DiscoverableURIs.Precedence.NORMAL).build();
        empty.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("a", new URI("bolt://www.example.com:8888"));
    }

    @Test
    public void shouldUsePassedURI() throws URISyntaxException {
        URI uri = new URI("bolt://www.example.com:9999");
        DiscoverableURIs empty = new DiscoverableURIs.Builder().add("a", uri, DiscoverableURIs.Precedence.NORMAL).build();
        empty.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("a", uri);
    }

    @Test
    public void shouldOverrideLowestForAbsolute() throws URISyntaxException {
        URI override = new URI("http://www.example.com:9999");
        DiscoverableURIs empty = new DiscoverableURIs.Builder().add("a", "bolt://localhost:8989", DiscoverableURIs.Precedence.LOWEST).overrideAbsolutesFromRequest(override).build();
        empty.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("a", new URI("bolt://www.example.com:8989"));
    }

    @Test
    public void shouldNotOverrideOtherThanLowestForAbsolute() throws URISyntaxException {
        URI override = new URI("http://www.example.com:9999");
        DiscoverableURIs empty = new DiscoverableURIs.Builder().add("a", "bolt://localhost:8989", DiscoverableURIs.Precedence.LOW).add("b", "bolt://localhost:8990", DiscoverableURIs.Precedence.NORMAL).add("c", "bolt://localhost:8991", DiscoverableURIs.Precedence.HIGH).add("d", "bolt://localhost:8992", DiscoverableURIs.Precedence.HIGHEST).overrideAbsolutesFromRequest(override).build();
        empty.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("a", new URI("bolt://localhost:8989"));
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("b", new URI("bolt://localhost:8990"));
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("c", new URI("bolt://localhost:8991"));
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.times((int)1))).accept("d", new URI("bolt://localhost:8992"));
    }
}

