/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.ServerBootstrapper;
import org.neo4j.server.database.CommunityGraphFactory;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.web.WebServer;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class ServerUserLogTest {
    @Rule
    public final SuppressOutput suppress = SuppressOutput.suppress((SuppressOutput.Suppressible[])new SuppressOutput.Suppressible[]{SuppressOutput.System.out});
    @Rule
    public TestDirectory homeDir = TestDirectory.testDirectory();

    @Test
    public void shouldLogToStdOutByDefault() throws Exception {
        ServerBootstrapper serverBootstrapper = this.getServerBootstrapper();
        File dir = this.homeDir.directory();
        serverBootstrapper.start(dir, Optional.empty(), MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.database_path.name(), this.homeDir.absolutePath().getAbsolutePath()}));
        Assert.assertThat(this.getStdOut(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Assert.assertTrue((!Files.exists(this.getUserLogFileLocation(dir), new LinkOption[0]) ? 1 : 0) != 0);
        serverBootstrapper.stop();
    }

    @Test
    public void shouldLogToFileWhenConfigured() throws Exception {
        ServerBootstrapper serverBootstrapper = this.getServerBootstrapper();
        File dir = this.homeDir.directory();
        serverBootstrapper.start(dir, Optional.empty(), MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.database_path.name(), this.homeDir.absolutePath().getAbsolutePath(), GraphDatabaseSettings.store_user_log_to_stdout.name(), "false"}));
        Assert.assertThat(this.getStdOut(), (Matcher)Matchers.empty());
        Assert.assertTrue((boolean)Files.exists(this.getUserLogFileLocation(dir), new LinkOption[0]));
        Assert.assertThat(this.readUserLogFile(dir), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        serverBootstrapper.stop();
    }

    private List<String> getStdOut() {
        List lines = this.suppress.getOutputVoice().lines();
        return lines.stream().filter(line -> !line.equals("")).collect(Collectors.toList());
    }

    private ServerBootstrapper getServerBootstrapper() {
        return new ServerBootstrapper(){

            protected GraphFactory createGraphFactory(Config config) {
                return new CommunityGraphFactory();
            }

            protected NeoServer createNeoServer(GraphFactory graphFactory, Config config, GraphDatabaseDependencies dependencies) {
                return new AbstractNeoServer(config, graphFactory, (GraphDatabaseFacadeFactory.Dependencies)dependencies){

                    protected Iterable<ServerModule> createServerModules() {
                        return new ArrayList<ServerModule>(0);
                    }

                    protected WebServer createWebServer() {
                        return null;
                    }

                    public Iterable<AdvertisableService> getServices() {
                        return new ArrayList<AdvertisableService>(0);
                    }
                };
            }
        };
    }

    private List<String> readUserLogFile(File homeDir) throws IOException {
        return Files.readAllLines(this.getUserLogFileLocation(homeDir)).stream().filter(line -> !line.equals("")).collect(Collectors.toList());
    }

    private Path getUserLogFileLocation(File homeDir) {
        return Paths.get(homeDir.getAbsolutePath(), "logs", "neo4j.log");
    }
}

