/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.database.SimpleGraphFactory;

public class LifecycleManagingDatabaseTest {
    @Test
    public void mustIgnoreExceptionsFromPreLoadingCypherQuery() {
        GraphDatabaseFacade mockDb = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
        Config config = Config.defaults();
        GraphDatabaseDependencies deps = GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)NullLogProvider.getInstance());
        SimpleGraphFactory factory = new SimpleGraphFactory(mockDb);
        LifecycleManagingDatabase db = new LifecycleManagingDatabase(config, factory, (GraphDatabaseFacadeFactory.Dependencies)deps){

            protected boolean isInTestMode() {
                return false;
            }
        };
        Mockito.when((Object)mockDb.execute("MATCH (a:` This query is just used to load the cypher compiler during warmup. Please ignore `) RETURN a LIMIT 0")).thenThrow(new Throwable[]{new TransactionFailureException("Boo")});
        db.init();
        db.start();
        Assert.assertTrue((String)"the database should be running", (boolean)db.isRunning());
        db.stop();
        db.shutdown();
    }
}

