/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import com.sun.jersey.api.client.Client;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;

public class DiscoveryServiceIT
extends AbstractRestFunctionalTestBase {
    @Test
    public void shouldRespondWith200WhenRetrievingDiscoveryDocument() {
        JaxRsResponse response = this.getDiscoveryDocument();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldGetContentLengthHeaderWhenRetrievingDiscoveryDocument() {
        JaxRsResponse response = this.getDiscoveryDocument();
        Assert.assertNotNull((Object)response.getHeaders().get((Object)"Content-Length"));
        response.close();
    }

    @Test
    public void shouldHaveJsonMediaTypeWhenRetrievingDiscoveryDocument() {
        JaxRsResponse response = this.getDiscoveryDocument();
        MatcherAssert.assertThat((Object)response.getType().toString(), (Matcher)Matchers.containsString((String)"application/json"));
        response.close();
    }

    @Test
    public void shouldHaveJsonDataInResponse() throws Exception {
        JaxRsResponse response = this.getDiscoveryDocument();
        Map map = JsonHelper.jsonToMap((String)response.getEntity());
        String managementKey = "management";
        Assert.assertTrue((boolean)map.containsKey(managementKey));
        Assert.assertNotNull(map.get(managementKey));
        String dataKey = "data";
        Assert.assertTrue((boolean)map.containsKey(dataKey));
        Assert.assertNotNull(map.get(dataKey));
        response.close();
    }

    @Test
    public void shouldRedirectOnHtmlRequest() {
        Client nonRedirectingClient = Client.create();
        nonRedirectingClient.setFollowRedirects(Boolean.valueOf(false));
        JaxRsResponse clientResponse = new RestRequest(null, nonRedirectingClient).get(DiscoveryServiceIT.server().baseUri().toString(), MediaType.TEXT_HTML_TYPE);
        Assert.assertEquals((long)303L, (long)clientResponse.getStatus());
    }

    private JaxRsResponse getDiscoveryDocument() {
        return new RestRequest(DiscoveryServiceIT.server().baseUri()).get();
    }
}

