/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.database.DatabaseService;
import org.neo4j.server.http.cypher.integration.TransactionMatchers;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.test.server.HTTP;

public class NeoServerIT
extends AbstractRestFunctionalTestBase {
    @Test
    public void whenServerIsStartedItShouldStartDatabaseService() {
        Assert.assertNotNull((Object)NeoServerIT.server().getDatabaseService());
        Assert.assertNotNull((Object)NeoServerIT.server().getDatabaseService().getDatabaseManagementService());
    }

    @Test
    public void whenServerIsStartedItShouldHaveAccessToSystemAndDefaultDatabase() {
        Assert.assertNotNull((Object)NeoServerIT.server().getDatabaseService().getSystemDatabase());
        Assert.assertNotNull((Object)NeoServerIT.server().getDatabaseService().getDatabase());
    }

    @Test
    public void shouldErrorForUnknownDatabase() {
        DatabaseService databaseService = NeoServerIT.server().getDatabaseService();
        DatabaseNotFoundException error = (DatabaseNotFoundException)Assertions.assertThrows(DatabaseNotFoundException.class, () -> databaseService.getDatabase("foo"));
        Assert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"foo"));
    }

    @Test
    public void shouldErrorForUnknownDatabaseViaTransactionalEndpoint() {
        HTTP.Response response = HTTP.POST(NeoServerIT.txCommitUri("foo"), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'RETURN 1' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)404));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Database.DatabaseNotFound}));
    }

    @Test
    public void shouldBeAbleToRunQueryAgainstSystemDatabaseViaTransactionalEndpoint() {
        HTTP.Response response = HTTP.POST(NeoServerIT.txCommitUri("system"), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'SHOW DEFAULT DATABASE' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.containsNoErrors());
    }

    @Test
    public void shouldRedirectRootToBrowser() {
        Assert.assertFalse((boolean)NeoServerIT.server().baseUri().toString().contains("browser"));
        HTTP.Response res = HTTP.withHeaders("Accept", "text/html").GET(NeoServerIT.server().baseUri().toString());
        Assert.assertThat((Object)res.header("Location"), (Matcher)Matchers.containsString((String)"browser"));
    }
}

