/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Test;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class TransactionTimeoutIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Test
    public void shouldHonorReallyLowSessionTimeout() throws Exception {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(ServerSettings.transaction_idle_timeout.name(), "1").build();
        this.server.start();
        String tx = HTTP.POST(this.txURI(), MapUtil.map((Object[])new Object[]{"statements", Arrays.asList(MapUtil.map((Object[])new Object[]{"statement", "CREATE (n)"}))})).location();
        Thread.sleep(5000L);
        Map response = (Map)HTTP.POST(tx + "/commit").content();
        List errors = (List)response.get("errors");
        MatcherAssert.assertThat(((Map)errors.get(0)).get("code"), (Matcher)CoreMatchers.equalTo((Object)Status.Transaction.TransactionNotFound.code().serialize()));
    }

    private String txURI() {
        return this.server.baseUri().toString() + TransactionTimeoutIT.txEndpoint();
    }
}

