/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.logging.Log;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.ServerBootstrapper;
import org.neo4j.server.database.CommunityGraphFactory;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class ServerUserLogTest {
    @Inject
    private SuppressOutput suppress;
    @Inject
    private TestDirectory homeDir;

    ServerUserLogTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldLogToStdOutByDefault() {
        ServerBootstrapper serverBootstrapper = ServerUserLogTest.getServerBootstrapper();
        File dir = this.homeDir.homeDir();
        Log logBeforeStart = serverBootstrapper.getLog();
        try {
            int returnCode = serverBootstrapper.start(dir, Optional.empty(), ServerUserLogTest.connectorsConfig());
            MatcherAssert.assertThat(this.getStdOut(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
            Assertions.assertFalse((boolean)Files.exists(ServerUserLogTest.getUserLogFileLocation(dir), new LinkOption[0]));
            Assertions.assertEquals((int)0, (int)returnCode);
            Assertions.assertTrue((boolean)serverBootstrapper.getServer().getDatabaseService().isRunning());
            MatcherAssert.assertThat((Object)serverBootstrapper.getLog(), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)logBeforeStart)));
            MatcherAssert.assertThat(this.getStdOut(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
            MatcherAssert.assertThat(this.getStdOut(), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Started.")));
        }
        finally {
            serverBootstrapper.stop();
        }
        Assertions.assertFalse((boolean)Files.exists(ServerUserLogTest.getUserLogFileLocation(dir), new LinkOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldLogToFileWhenConfigured() throws Exception {
        ServerBootstrapper serverBootstrapper = ServerUserLogTest.getServerBootstrapper();
        File dir = this.homeDir.homeDir();
        Log logBeforeStart = serverBootstrapper.getLog();
        try {
            Map configOverrides = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_user_log_to_stdout.name(), "false"});
            configOverrides.putAll(ServerUserLogTest.connectorsConfig());
            int returnCode = serverBootstrapper.start(dir, Optional.empty(), configOverrides);
            Assertions.assertEquals((int)0, (int)returnCode);
            Assertions.assertTrue((boolean)serverBootstrapper.getServer().getDatabaseService().isRunning());
            MatcherAssert.assertThat((Object)serverBootstrapper.getLog(), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)logBeforeStart)));
        }
        finally {
            serverBootstrapper.stop();
        }
        MatcherAssert.assertThat(this.getStdOut(), (Matcher)Matchers.empty());
        Assertions.assertTrue((boolean)Files.exists(ServerUserLogTest.getUserLogFileLocation(dir), new LinkOption[0]));
        MatcherAssert.assertThat(ServerUserLogTest.readUserLogFile(dir), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(ServerUserLogTest.readUserLogFile(dir), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Started.")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void logShouldRotateWhenConfigured() throws Exception {
        ServerBootstrapper serverBootstrapper = ServerUserLogTest.getServerBootstrapper();
        File dir = this.homeDir.homeDir();
        Log logBeforeStart = serverBootstrapper.getLog();
        int maxArchives = 4;
        try {
            Map configOverrides = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_user_log_to_stdout.name(), "false", GraphDatabaseSettings.store_user_log_rotation_delay.name(), "0", GraphDatabaseSettings.store_user_log_rotation_threshold.name(), "16", GraphDatabaseSettings.store_user_log_max_archives.name(), Integer.toString(maxArchives)});
            configOverrides.putAll(ServerUserLogTest.connectorsConfig());
            int returnCode = serverBootstrapper.start(dir, Optional.empty(), configOverrides);
            Assertions.assertEquals((int)0, (int)returnCode);
            MatcherAssert.assertThat((Object)serverBootstrapper.getLog(), (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)logBeforeStart)));
            Assertions.assertTrue((boolean)serverBootstrapper.getServer().getDatabaseService().isRunning());
            do {
                serverBootstrapper.getLog().info("testing 123. This string should contain more than 16 bytes\n");
                Thread.sleep(2000L);
            } while (ServerUserLogTest.allUserLogFiles(dir).size() <= 4);
        }
        finally {
            serverBootstrapper.stop();
        }
        MatcherAssert.assertThat(this.getStdOut(), (Matcher)Matchers.empty());
        Assertions.assertTrue((boolean)Files.exists(ServerUserLogTest.getUserLogFileLocation(dir), new LinkOption[0]));
        MatcherAssert.assertThat(ServerUserLogTest.readUserLogFile(dir), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        List<String> userLogFiles = ServerUserLogTest.allUserLogFiles(dir);
        MatcherAssert.assertThat(userLogFiles, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"neo4j.log", "neo4j.log.1", "neo4j.log.2", "neo4j.log.3", "neo4j.log.4"}));
        Assertions.assertEquals((int)(maxArchives + 1), (int)userLogFiles.size());
    }

    private static Map<String, String> connectorsConfig() {
        return Map.of(HttpConnector.listen_address.name(), "localhost:0", BoltConnector.listen_address.name(), "localhost:0", HttpsConnector.listen_address.name(), "localhost:0");
    }

    private List<String> getStdOut() {
        List lines = this.suppress.getOutputVoice().lines();
        return lines.stream().filter(line -> !line.equals("")).collect(Collectors.toList());
    }

    private static ServerBootstrapper getServerBootstrapper() {
        return new ServerBootstrapper(){

            protected GraphFactory createGraphFactory(Config config) {
                return new CommunityGraphFactory();
            }

            protected NeoServer createNeoServer(GraphFactory graphFactory, Config config, GraphDatabaseDependencies dependencies) {
                dependencies.userLogProvider();
                return new AbstractNeoServer(config, graphFactory, (ExternalDependencies)dependencies){

                    protected Iterable<ServerModule> createServerModules() {
                        return new ArrayList<ServerModule>(0);
                    }

                    protected void configureWebServer() {
                    }

                    protected void startWebServer() {
                    }

                    protected WebServer createWebServer() {
                        return null;
                    }
                };
            }
        };
    }

    private static List<String> readUserLogFile(File homeDir) throws IOException {
        return Files.readAllLines(ServerUserLogTest.getUserLogFileLocation(homeDir)).stream().filter(line -> !line.equals("")).collect(Collectors.toList());
    }

    private static Path getUserLogFileLocation(File homeDir) {
        return Paths.get(homeDir.getAbsolutePath(), "logs", "neo4j.log");
    }

    private static List<String> allUserLogFiles(File homeDir) throws IOException {
        try (Stream<String> stream = Files.list(Paths.get(homeDir.getAbsolutePath(), "logs")).map(x -> x.getFileName().toString()).filter(x -> x.contains("neo4j.log"));){
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }
}

