/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.io.File;
import java.io.IOException;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.Transactor;
import org.neo4j.server.helpers.UnitOfWork;

public class ServerHelper {
    private ServerHelper() {
    }

    public static void cleanTheDatabase(NeoServer server) {
        if (server == null) {
            return;
        }
        ServerHelper.rollbackAllOpenTransactions(server);
        ServerHelper.cleanTheDatabase((GraphDatabaseAPI)server.getDatabaseService().getDatabase());
    }

    public static void cleanTheDatabase(GraphDatabaseAPI db) {
        new Transactor((GraphDatabaseService)db, new DeleteAllData(db), 10).execute();
        new Transactor((GraphDatabaseService)db, new DeleteAllSchema(), 10).execute();
    }

    public static NeoServer createNonPersistentServer() throws IOException {
        return ServerHelper.createServer(CommunityServerBuilder.server(), false, null);
    }

    public static NeoServer createReadOnlyServer(File path) throws IOException {
        CommunityServerBuilder builder = CommunityServerBuilder.server();
        builder.withProperty("dbms.connector.bolt.listen_address", ":0");
        ServerHelper.createServer(builder, true, path).stop();
        builder.withProperty(GraphDatabaseSettings.read_only.name(), "true");
        return ServerHelper.createServer(builder, true, path);
    }

    public static NeoServer createNonPersistentServer(LogProvider logProvider) throws IOException {
        return ServerHelper.createServer(CommunityServerBuilder.server(logProvider), false, null);
    }

    public static NeoServer createNonPersistentServer(CommunityServerBuilder builder) throws IOException {
        return ServerHelper.createServer(builder, false, null);
    }

    private static NeoServer createServer(CommunityServerBuilder builder, boolean persistent, File path) throws IOException {
        if (persistent) {
            builder = builder.persistent();
        }
        builder.onRandomPorts();
        CommunityNeoServer server = builder.usingDataDir(path != null ? path.getAbsolutePath() : null).build();
        server.start();
        return server;
    }

    private static void rollbackAllOpenTransactions(NeoServer server) {
        server.getTransactionRegistry().rollbackAllSuspendedTransactions();
    }

    private static class DeleteAllSchema
    implements UnitOfWork {
        private DeleteAllSchema() {
        }

        @Override
        public void doWork(Transaction transaction) {
            this.deleteAllIndexRules(transaction);
            this.deleteAllConstraints(transaction);
        }

        private void deleteAllIndexRules(Transaction transaction) {
            for (IndexDefinition index : transaction.schema().getIndexes()) {
                if (index.isConstraintIndex()) continue;
                index.drop();
            }
        }

        private void deleteAllConstraints(Transaction transaction) {
            for (ConstraintDefinition constraint : transaction.schema().getConstraints()) {
                constraint.drop();
            }
        }
    }

    private static class DeleteAllData
    implements UnitOfWork {
        private final GraphDatabaseAPI db;

        DeleteAllData(GraphDatabaseAPI db) {
            this.db = db;
        }

        @Override
        public void doWork(Transaction transaction) {
            this.deleteAllNodesAndRelationships(transaction);
        }

        private void deleteAllNodesAndRelationships(Transaction tx) {
            ResourceIterable allNodes = tx.getAllNodes();
            for (Node n : allNodes) {
                Iterable relationships = n.getRelationships();
                for (Relationship rel : relationships) {
                    rel.delete();
                }
                n.delete();
            }
        }
    }
}

