/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.eclipse.jetty.http.HttpHeader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.InsecureTrustManager;

public class HttpHeadersIT
extends ExclusiveServerTestBase {
    private static final String HSTS_HEADER_VALUE = "max-age=31536000; includeSubDomains; preload";
    private CommunityNeoServer server;

    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void shouldNotSendJettyVersionWithHttpResponseHeaders() throws Exception {
        this.startServer();
        HttpHeadersIT.testNoJettyVersionInResponseHeaders(this.httpUri());
    }

    @Test
    public void shouldNotSendJettyVersionWithHttpsResponseHeaders() throws Exception {
        this.startServer();
        HttpHeadersIT.testNoJettyVersionInResponseHeaders(this.httpsUri());
    }

    @Test
    public void shouldNotSendHstsHeaderWithHttpResponse() throws Exception {
        this.startServer(HSTS_HEADER_VALUE);
        Assert.assertNull((Object)HttpHeadersIT.runRequestAndGetHstsHeaderValue(this.httpUri()));
    }

    @Test
    public void shouldSendHstsHeaderWithHttpsResponse() throws Exception {
        this.startServer(HSTS_HEADER_VALUE);
        Assert.assertEquals((Object)HSTS_HEADER_VALUE, (Object)HttpHeadersIT.runRequestAndGetHstsHeaderValue(this.httpsUri()));
    }

    @Test
    public void shouldNotSendHstsHeaderWithHttpsResponseWhenNotConfigured() throws Exception {
        this.startServer();
        Assert.assertNull((Object)HttpHeadersIT.runRequestAndGetHstsHeaderValue(this.httpsUri()));
    }

    private void startServer() throws Exception {
        this.startServer(null);
    }

    private void startServer(String hstsValue) throws Exception {
        this.server = this.buildServer(hstsValue);
        this.server.start();
    }

    private CommunityNeoServer buildServer(String hstsValue) throws Exception {
        CommunityServerBuilder builder = CommunityServerBuilder.serverOnRandomPorts().withHttpsEnabled().usingDataDir(this.folder.directory(this.name.getMethodName(), new String[0]).getAbsolutePath());
        if (hstsValue != null) {
            builder.withProperty(ServerSettings.http_strict_transport_security.name(), hstsValue);
        }
        return builder.build();
    }

    private URI httpUri() {
        return this.server.baseUri();
    }

    private URI httpsUri() {
        return (URI)this.server.httpsUri().orElseThrow(IllegalStateException::new);
    }

    private static void testNoJettyVersionInResponseHeaders(URI baseUri) throws Exception {
        Map<String, List<String>> headers = HttpHeadersIT.runRequestAndGetHeaders(baseUri);
        Assert.assertNull(headers.get(HttpHeader.SERVER.asString()));
        for (List<String> values : headers.values()) {
            Assert.assertFalse((boolean)values.stream().anyMatch(value -> value.toLowerCase().contains("jetty")));
        }
    }

    private static String runRequestAndGetHstsHeaderValue(URI baseUri) throws Exception {
        return HttpHeadersIT.runRequestAndGetHeaderValue(baseUri, HttpHeader.STRICT_TRANSPORT_SECURITY.asString());
    }

    private static String runRequestAndGetHeaderValue(URI baseUri, String header) throws Exception {
        List<String> values = HttpHeadersIT.runRequestAndGetHeaderValues(baseUri, header);
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        throw new IllegalStateException("Unexpected number of " + HttpHeader.STRICT_TRANSPORT_SECURITY.asString() + " header values: " + values);
    }

    private static List<String> runRequestAndGetHeaderValues(URI baseUri, String header) throws Exception {
        return HttpHeadersIT.runRequestAndGetHeaders(baseUri).getOrDefault(header, Collections.emptyList());
    }

    private static Map<String, List<String>> runRequestAndGetHeaders(URI baseUri) throws Exception {
        URI uri = baseUri.resolve(HttpHeadersIT.txCommitEndpoint());
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").POST(HttpRequest.BodyPublishers.noBody()).build();
        SSLContext trustAllSslContext = SSLContext.getInstance("TLS");
        trustAllSslContext.init(null, new TrustManager[]{new InsecureTrustManager()}, null);
        HttpClient client = HttpClient.newBuilder().sslContext(trustAllSslContext).connectTimeout(Duration.ofMinutes(1L)).build();
        HttpResponse<Void> response = client.sendAsync(request, HttpResponse.BodyHandlers.discarding()).get(1L, TimeUnit.MINUTES);
        Assert.assertEquals((long)200L, (long)response.statusCode());
        return response.headers().map();
    }
}

