/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerStartupLoggingIT
extends ExclusiveServerTestBase {
    private static ByteArrayOutputStream out;
    private static NeoServer server;

    @BeforeClass
    public static void setupServer() throws IOException {
        out = new ByteArrayOutputStream();
        server = ServerHelper.createNonPersistentServer((LogProvider)FormattedLogProvider.toOutputStream((OutputStream)out));
    }

    @Before
    public void cleanTheDatabase() {
        ServerHelper.cleanTheDatabase(server);
    }

    @AfterClass
    public static void stopServer() {
        server.stop();
    }

    @Test
    public void shouldLogStartup() throws Exception {
        String logContent = out.toString();
        Assert.assertThat((Object)logContent.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)logContent, (Matcher)Matchers.containsString((String)AbstractNeoServer.NEO4J_IS_STARTING_MESSAGE));
        HttpRequest request = HttpRequest.newBuilder(server.baseUri()).GET().build();
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();
        HttpResponse<Void> response = client.send(request, HttpResponse.BodyHandlers.discarding());
        Assert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(199))));
    }
}

