/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.ServerCommandLineArgs;

public class ServerCommandLineArgsTest {
    @Test
    public void shouldPickUpSpecifiedConfigFile() {
        File dir = new File("/some-dir").getAbsoluteFile();
        Optional<File> expectedFile = Optional.of(new File(dir, "neo4j.conf"));
        Assert.assertEquals(expectedFile, (Object)this.parse("--config-dir", dir.toString()).configFile());
        Assert.assertEquals(expectedFile, (Object)this.parse("--config-dir=" + dir).configFile());
    }

    @Test
    public void shouldResolveConfigFileRelativeToWorkingDirectory() {
        Optional<File> expectedFile = Optional.of(new File("some-dir", "neo4j.conf"));
        Assert.assertEquals(expectedFile, (Object)this.parse("--config-dir", "some-dir").configFile());
        Assert.assertEquals(expectedFile, (Object)this.parse("--config-dir=some-dir").configFile());
    }

    @Test
    public void shouldReturnNullIfConfigDirIsNotSpecified() {
        Assert.assertEquals(Optional.empty(), (Object)this.parse(new String[0]).configFile());
    }

    @Test
    public void shouldPickUpSpecifiedHomeDir() {
        File homeDir = new File("/some/absolute/homedir").getAbsoluteFile();
        Assert.assertEquals((Object)homeDir, (Object)this.parse("--home-dir", homeDir.toString()).homeDir());
        Assert.assertEquals((Object)homeDir, (Object)this.parse("--home-dir=" + homeDir.toString()).homeDir());
    }

    @Test
    public void shouldReturnNullIfHomeDirIsNotSpecified() {
        Assert.assertNull((Object)this.parse(new String[0]).homeDir());
    }

    @Test
    public void shouldPickUpOverriddenConfigurationParameters() {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "myoption=myvalue"});
        ServerCommandLineArgs parsed = ServerCommandLineArgs.parse((String[])args);
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{"myoption", "myvalue"}), (Object)parsed.configOverrides());
    }

    @Test
    public void shouldPickUpOverriddenBooleanConfigurationParameters() {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "myoptionenabled"});
        ServerCommandLineArgs parsed = ServerCommandLineArgs.parse((String[])args);
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{"myoptionenabled", Boolean.TRUE.toString()}), (Object)parsed.configOverrides());
    }

    @Test
    public void shouldPickUpMultipleOverriddenConfigurationParameters() {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "my_first_option=first", "-c", "myoptionenabled", "-c", "my_second_option=second"});
        ServerCommandLineArgs parsed = ServerCommandLineArgs.parse((String[])args);
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{"my_first_option", "first", "myoptionenabled", Boolean.TRUE.toString(), "my_second_option", "second"}), (Object)parsed.configOverrides());
    }

    private ServerCommandLineArgs parse(String ... args) {
        return ServerCommandLineArgs.parse((String[])args);
    }
}

