/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.junit.Assert;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class ServerTestUtils {
    private ServerTestUtils() {
    }

    public static File createTempDir() throws IOException {
        return Files.createTempDirectory("neo4j-test", new FileAttribute[0]).toFile();
    }

    public static File createTempConfigFile() throws IOException {
        File file = File.createTempFile("neo4j", "conf");
        file.delete();
        return file;
    }

    public static Path getRelativePath(File folder, Setting<Path> setting) {
        return folder.toPath().resolve((Path)setting.defaultValue());
    }

    public static Map<String, String> getDefaultRelativeProperties(File folder) {
        HashMap<String, String> settings = new HashMap<String, String>();
        ServerTestUtils.addDefaultRelativeProperties(settings, folder);
        return settings;
    }

    public static void addDefaultRelativeProperties(Map<String, String> properties, File temporaryFolder) {
        ServerTestUtils.addRelativeProperty(temporaryFolder, properties, (Setting<Path>)GraphDatabaseSettings.data_directory);
        ServerTestUtils.addRelativeProperty(temporaryFolder, properties, (Setting<Path>)GraphDatabaseSettings.logs_directory);
        properties.put(GraphDatabaseSettings.pagecache_memory.name(), "8m");
    }

    private static void addRelativeProperty(File temporaryFolder, Map<String, String> properties, Setting<Path> setting) {
        properties.put(setting.name(), ServerTestUtils.getRelativePath(temporaryFolder, setting).toString());
    }

    public static void writeConfigToFile(Map<String, String> properties, File file) {
        Properties props = ServerTestUtils.loadProperties(file);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        ServerTestUtils.storeProperties(file, props);
    }

    public static String asOneLine(Map<String, String> properties) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            builder.append(builder.length() > 0 ? "," : "");
            builder.append(property.getKey()).append("=").append(property.getValue());
        }
        return builder.toString();
    }

    private static void storeProperties(File file, Properties properties) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            properties.store(out, "");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ServerTestUtils.safeClose(out);
                throw throwable;
            }
        }
        ServerTestUtils.safeClose(out);
    }

    private static Properties loadProperties(File file) {
        Properties properties = new Properties();
        if (file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                properties.load(in);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    ServerTestUtils.safeClose(in);
                    throw throwable;
                }
            }
            ServerTestUtils.safeClose(in);
        }
        return properties;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File createTempConfigFile(File parentDir) {
        File file = new File(parentDir, "test-" + new Random().nextInt() + ".properties");
        file.deleteOnExit();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withCSVFile(int rowCount, BlockWithCSVFileURL block) throws Exception {
        File file = File.createTempFile("file", ".csv", null);
        try {
            try (PrintWriter writer = new PrintWriter(file);){
                for (int i = 0; i < rowCount; ++i) {
                    writer.println("1,2,3");
                }
            }
            String url = file.toURI().toURL().toString().replace("\\", "\\\\");
            block.execute(url);
        }
        finally {
            file.delete();
        }
    }

    public static void verifyConnector(GraphDatabaseService db, String name, boolean enabled) {
        HostnamePort address = ServerTestUtils.connectorAddress(db, name);
        if (enabled) {
            Assert.assertNotNull((Object)address);
            Assert.assertTrue((boolean)ServerTestUtils.canConnectToSocket(address.getHost(), address.getPort()));
        } else {
            Assert.assertNull((Object)address);
        }
    }

    public static HostnamePort connectorAddress(GraphDatabaseService db, String name) {
        ConnectorPortRegister portRegister = (ConnectorPortRegister)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
        return portRegister.getLocalAddress(name);
    }

    private static boolean canConnectToSocket(String host, int port) {
        try {
            new Socket(host, port).close();
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public static interface BlockWithCSVFileURL {
        public void execute(String var1) throws Exception;
    }
}

