/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class StartupLoggingIT
extends ExclusiveServerTestBase {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();

    @Test
    public void shouldLogHelpfulStartupMessages() {
        CommunityBootstrapper boot = new CommunityBootstrapper();
        Map<String, String> propertyPairs = this.getPropertyPairs();
        boot.start(this.testDir.homeDir(), Optional.of(new File("nonexistent-file.conf")), propertyPairs);
        URI uri = boot.getServer().baseUri();
        boot.stop();
        List captured = this.suppressOutput.getOutputVoice().lines();
        MatcherAssert.assertThat((Object)captured, StartupLoggingIT.containsAtLeastTheseLines(StartupLoggingIT.warn("Config file \\[nonexistent-file.conf\\] does not exist."), StartupLoggingIT.info(AbstractNeoServer.NEO4J_IS_STARTING_MESSAGE), StartupLoggingIT.info("Starting..."), StartupLoggingIT.info("Started."), StartupLoggingIT.info("Remote interface available at " + uri.toString()), StartupLoggingIT.info("Stopping..."), StartupLoggingIT.info("Stopped.")));
    }

    private Map<String, String> getPropertyPairs() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(GraphDatabaseSettings.data_directory.name(), this.testDir.homeDir().toString());
        properties.put(GraphDatabaseSettings.logs_directory.name(), this.testDir.homeDir().toString());
        properties.put(GraphDatabaseSettings.allow_upgrade.name(), "true");
        properties.put(HttpConnector.listen_address.name(), "localhost:0");
        properties.put(HttpConnector.enabled.name(), "true");
        properties.put(HttpsConnector.listen_address.name(), "localhost:0");
        properties.put(HttpsConnector.enabled.name(), "false");
        properties.put(BoltConnector.enabled.name(), "true");
        properties.put(BoltConnector.listen_address.name(), "localhost:0");
        properties.put(BoltConnector.encryption_level.name(), "DISABLED");
        properties.put(GraphDatabaseSettings.databases_root_path.name(), this.testDir.absolutePath().getAbsolutePath());
        return properties;
    }

    @SafeVarargs
    private static Matcher<List<String>> containsAtLeastTheseLines(final Matcher<String> ... expectedLinePatterns) {
        return new TypeSafeMatcher<List<String>>(){

            protected boolean matchesSafely(List<String> lines) {
                if (expectedLinePatterns.length > lines.size()) {
                    return false;
                }
                int e = 0;
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    while (!expectedLinePatterns[e].matches((Object)line)) {
                        if (++i >= lines.size()) {
                            return false;
                        }
                        line = lines.get(i);
                    }
                    ++e;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendList("", "\n", "", Arrays.asList(expectedLinePatterns));
            }
        };
    }

    public static Matcher<String> info(String messagePattern) {
        return StartupLoggingIT.line("INFO", messagePattern);
    }

    public static Matcher<String> warn(String messagePattern) {
        return StartupLoggingIT.line("WARN", messagePattern);
    }

    public static Matcher<String> line(final String level, final String messagePattern) {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String line) {
                return line.matches(".*" + level + "\\s+" + messagePattern);
            }

            public void describeTo(Description description) {
                description.appendText(level).appendText(" ").appendText(messagePattern);
            }
        };
    }
}

