/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.input.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.http.cypher.format.api.InputFormatException;
import org.neo4j.server.http.cypher.format.input.json.InputStatement;
import org.neo4j.server.http.cypher.format.input.json.StatementDeserializer;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.string.UTF8;

public class StatementDeserializerTest {
    private final JsonFactory jsonFactory = new JsonFactory().setCodec((ObjectCodec)new ObjectMapper());

    @Test
    public void shouldDeserializeSingleStatement() {
        String json = JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"statements", Collections.singletonList(MapUtil.map((Object[])new Object[]{"statement", "Blah blah", "parameters", MapUtil.map((Object[])new Object[]{"one", 12})}))}));
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        InputStatement stmt = de.read();
        Assert.assertNotNull((Object)stmt);
        MatcherAssert.assertThat((Object)stmt.statement(), (Matcher)Matchers.equalTo((Object)"Blah blah"));
        MatcherAssert.assertThat((Object)stmt.parameters(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"one", 12})));
        Assert.assertNull((Object)de.read());
    }

    @Test
    public void shouldRejectMapWithADifferentFieldBeforeStatement() {
        String json = "{ \"timeout\" : 200, \"statements\" : [ { \"statement\" : \"ignored\", \"parameters\" : {}} ] }";
        this.assertYieldsErrors(json, "Unable to deserialize request. Expected first field to be 'statements', but was 'timeout'.");
    }

    @Test
    public void shouldTotallyIgnoreInvalidJsonAfterStatementArrayHasFinished() {
        String json = "{ \"statements\" : [ { \"statement\" : \"Blah blah\", \"parameters\" : {\"one\" : 12}} ] totally invalid json is totally ignored";
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        InputStatement stmt = de.read();
        Assert.assertNotNull((Object)stmt);
        MatcherAssert.assertThat((Object)stmt.statement(), (Matcher)Matchers.equalTo((Object)"Blah blah"));
        Assert.assertNull((Object)de.read());
    }

    @Test
    public void shouldIgnoreUnknownFields() {
        String json = "{ \"statements\" : [ { \"a\" : \"\", \"b\" : { \"k\":1 }, \"statement\" : \"blah\" } ] }";
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        InputStatement stmt = de.read();
        Assert.assertNotNull((Object)stmt);
        MatcherAssert.assertThat((Object)stmt.statement(), (Matcher)Matchers.equalTo((Object)"blah"));
        Assert.assertNull((Object)de.read());
    }

    @Test
    public void shouldTakeParametersBeforeStatement() {
        String json = "{ \"statements\" : [ { \"a\" : \"\", \"parameters\" : { \"k\":1 }, \"statement\" : \"blah\"}]}";
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        InputStatement stmt = de.read();
        Assert.assertNotNull((Object)stmt);
        MatcherAssert.assertThat((Object)stmt.statement(), (Matcher)Matchers.equalTo((Object)"blah"));
        MatcherAssert.assertThat((Object)stmt.parameters(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"k", 1})));
        Assert.assertNull((Object)de.read());
    }

    @Test
    public void shouldTreatEmptyInputStreamAsEmptyStatementList() {
        byte[] json = new byte[]{};
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(json));
        Assert.assertNull((Object)de.read());
    }

    @Test
    public void shouldDeserializeMultipleStatements() {
        String json = JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"statements", Arrays.asList(MapUtil.map((Object[])new Object[]{"statement", "Blah blah", "parameters", MapUtil.map((Object[])new Object[]{"one", 12})}), MapUtil.map((Object[])new Object[]{"statement", "Blah bluh", "parameters", MapUtil.map((Object[])new Object[]{"asd", Collections.singletonList("one, two")})}))}));
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        InputStatement stmt = de.read();
        Assert.assertNotNull((Object)stmt);
        MatcherAssert.assertThat((Object)stmt.statement(), (Matcher)Matchers.equalTo((Object)"Blah blah"));
        MatcherAssert.assertThat((Object)stmt.parameters(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"one", 12})));
        InputStatement stmt2 = de.read();
        Assert.assertNotNull((Object)stmt2);
        MatcherAssert.assertThat((Object)stmt2.statement(), (Matcher)Matchers.equalTo((Object)"Blah bluh"));
        MatcherAssert.assertThat((Object)stmt2.parameters(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"asd", Collections.singletonList("one, two")})));
        Assert.assertNull((Object)de.read());
    }

    @Test
    public void shouldNotThrowButReportErrorOnInvalidInput() {
        this.assertYieldsErrors("{}", "Unable to deserialize request. Expected [START_OBJECT, FIELD_NAME, START_ARRAY], found [START_OBJECT, END_OBJECT, null].");
        this.assertYieldsErrors("{ \"statements\":\"WAIT WAT A STRING NOO11!\" }", "Unable to deserialize request. Expected [START_OBJECT, FIELD_NAME, START_ARRAY], found [START_OBJECT, FIELD_NAME, VALUE_STRING].");
        this.assertYieldsErrors("[{]}", "Could not parse the incoming JSON", "Unexpected close marker ']': expected '}' (for Object starting at [Source: (ByteArrayInputStream); line: 1, column: 2])\n at [Source: (ByteArrayInputStream); line: 1, column: 4]");
        this.assertYieldsErrors("{ \"statements\" : \"ITS A STRING\" }", "Unable to deserialize request. Expected [START_OBJECT, FIELD_NAME, START_ARRAY], found [START_OBJECT, FIELD_NAME, VALUE_STRING].");
        this.assertYieldsErrors("{ \"statements\" : [ { \"statement\" : [\"dd\"] } ] }", "Could not map the incoming JSON", "Cannot deserialize instance of `java.lang.String` out of START_ARRAY token\n at [Source: (ByteArrayInputStream); line: 1, column: 36]");
        this.assertYieldsErrors("{ \"statements\" : [ { \"statement\" : \"stmt\", \"parameters\" : [\"AN ARRAY!!\"] } ] }", "Could not map the incoming JSON", "Cannot deserialize instance of `java.util.LinkedHashMap<java.lang.Object,java.lang.Object>` out of START_ARRAY token\n at [Source: (ByteArrayInputStream); line: 1, column: 59]");
    }

    private void assertYieldsErrors(String json, String ... expectedErrorMessages) {
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        try {
            while (de.read() != null) {
            }
            Assert.fail((String)"An exception should have been thrown");
        }
        catch (InputFormatException e) {
            ArrayList<String> errorMessages = new ArrayList<String>();
            errorMessages.add(e.getMessage());
            Throwable t = e;
            while ((t = t.getCause()) != null) {
                errorMessages.add(t.getMessage());
            }
            MatcherAssert.assertThat(errorMessages, (Matcher)Matchers.equalTo(Arrays.asList(expectedErrorMessages)));
        }
    }
}

