/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.common.Neo4jJsonCodec;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContentWriter;
import org.neo4j.server.http.cypher.format.output.json.RowWriter;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;

class RowWriterTest {
    RowWriterTest() {
    }

    @Test
    void shouldWriteNestedMaps() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator json = new JsonFactory((ObjectCodec)new Neo4jJsonCodec()).createJsonGenerator((OutputStream)out);
        JsonNode row = this.serialize(out, json, (ResultDataContentWriter)new RowWriter());
        MatcherAssert.assertThat((Object)row.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        JsonNode firstCell = row.get(0);
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").get(0).asBoolean(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").get(1).get("three").asInt(), (Matcher)CoreMatchers.is((Object)42));
    }

    private JsonNode serialize(ByteArrayOutputStream out, JsonGenerator json, ResultDataContentWriter resultDataContentWriter) throws IOException, JsonParseException {
        Map data = MapUtil.map((Object[])new Object[]{"the column", MapUtil.map((Object[])new Object[]{"one", MapUtil.map((Object[])new Object[]{"two", Arrays.asList(true, MapUtil.map((Object[])new Object[]{"three", 42}))})})});
        RecordEvent recordEvent = new RecordEvent(Collections.singletonList("the column"), data::get);
        json.writeStartObject();
        resultDataContentWriter.write(json, recordEvent, null);
        json.writeEndObject();
        json.flush();
        json.close();
        String jsonAsString = out.toString();
        return JsonHelper.jsonNode((String)jsonAsString).get("row");
    }
}

