/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.http.cypher.integration.TransactionMatchers;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

public class QueryResultsSerializationTest
extends AbstractRestFunctionalTestBase {
    private final HTTP.Builder http = HTTP.withBaseUri(QueryResultsSerializationTest.server().baseUri());
    private String commitResource;

    @Before
    public void setUp() {
        HTTP.Response begin = this.http.POST(QueryResultsSerializationTest.txUri());
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        QueryResultsSerializationTest.assertHasTxLocation(begin);
        try {
            this.commitResource = begin.stringFromContent("commit");
        }
        catch (JsonParseException e) {
            Assert.fail((String)("Exception caught when setting up test: " + e.getMessage()));
        }
        MatcherAssert.assertThat((Object)this.commitResource, (Matcher)CoreMatchers.equalTo((Object)(begin.location() + "/commit")));
    }

    @After
    public void tearDown() {
        this.executeTransactionally("MATCH (n) DETACH DELETE n");
    }

    @Test
    public void shouldBeAbleToReturnDeletedEntitiesGraph() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (s:Start)-[r:R]->(e:End) DELETE s, r, e RETURN *"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedRelationships(1));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedNodes(2));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedEntitiesRest() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (s:Start)-[r:R]->(e:End) DELETE s, r, e RETURN *"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.restContainsDeletedEntities(3));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedEntitiesRow() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (s:Start)-[r:R]->(e:End) DELETE s, r, e RETURN *"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsDeletedEntities(2, 1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldNotMarkNormalEntitiesAsDeletedGraph() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (s:Start)-[r:R]->(e:End) RETURN *"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsNoDeletedEntities());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    @Test
    public void shouldNotMarkNormalEntitiesAsDeletedRow() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (s:Start)-[r:R]->(e:End) RETURN *"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsNoDeletedEntities());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    @Test
    public void shouldNotMarkNormalEntitiesAsDeletedRest() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (s:Start)-[r:R]->(e:End) RETURN *"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.restContainsNoDeletedEntities());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    @Test
    public void shouldBeAbleToReturnDeletedNodesGraph() {
        this.executeTransactionally("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (n:NodeToDelete) DELETE n RETURN n"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedNodes(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedNodesRow() {
        this.executeTransactionally("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (n:NodeToDelete) DELETE n RETURN n"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsDeletedEntities(1, 0));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedNodesRest() {
        this.executeTransactionally("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (n:NodeToDelete) DELETE n RETURN n"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.restContainsDeletedEntities(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedRelationshipsGraph() {
        this.executeTransactionally("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (s)-[r:R]->(e) DELETE r RETURN r"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedRelationships(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedRelationshipsRow() {
        this.executeTransactionally("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (s)-[r:R]->(e) DELETE r RETURN r"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsDeletedEntities(0, 1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedRelationshipsRest() {
        this.executeTransactionally("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (s)-[r:R]->(e) DELETE r RETURN r"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.restContainsDeletedEntities(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedNodeGraph() {
        this.executeTransactionally("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (n:NodeToDelete) DELETE n RETURN n.p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedNodeRow() {
        this.executeTransactionally("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (n:NodeToDelete) DELETE n RETURN n.p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedNodeRest() {
        this.executeTransactionally("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (n:NodeToDelete) DELETE n RETURN n.p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldFailIfTryingToReturnLabelsOfDeletedNodeGraph() {
        this.executeTransactionally("CREATE (:NodeToDelete)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (n:NodeToDelete) DELETE n RETURN labels(n)"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldFailIfTryingToReturnLabelsOfDeletedNodeRow() {
        this.executeTransactionally("CREATE (:NodeToDelete)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (n:NodeToDelete) DELETE n RETURN labels(n)"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldFailIfTryingToReturnLabelsOfDeletedNodeRest() {
        this.executeTransactionally("CREATE (:NodeToDelete)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (n:NodeToDelete) DELETE n RETURN labels(n)"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedRelationshipGraph() {
        this.executeTransactionally("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (s)-[r:R]->(e) DELETE r RETURN r.p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedRelationshipRow() {
        this.executeTransactionally("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (s)-[r:R]->(e) DELETE r RETURN r.p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedRelationshipRest() {
        this.executeTransactionally("CREATE (:Start)-[:MARKER {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (s)-[r:MARKER]->(e) DELETE r RETURN r.p"));
        MatcherAssert.assertThat((String)("Error raw response: " + commit.rawContent()), (Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void returningADeletedPathGraph() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH p=(s)-[r:R]->(e) DELETE p RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedNodes(2));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedRelationships(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void returningAPartiallyDeletedPathGraph() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH p=(s)-[r:R]->(e) DELETE s,r RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedNodes(1));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedRelationships(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void returningADeletedPathRow() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH p=(s)-[r:R]->(e) DELETE p RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsDeletedEntitiesInPath(2, 1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void returningAPartiallyDeletedPathRow() {
        String query = "CREATE (:Start)-[:R]->(:End)";
        this.executeTransactionally(query);
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH p=(s)-[r:R]->(e) DELETE s,r RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsDeletedEntitiesInPath(1, 1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    private void executeTransactionally(String query) {
        GraphDatabaseService database = this.graphdb();
        try (Transaction transaction = database.beginTx();){
            transaction.execute(query);
            transaction.commit();
        }
    }

    @Test
    public void returningADeletedPathRest() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH p=(s)-[r:R]->(e) DELETE p RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void returningAPartiallyDeletedPathRest() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH p=(s)-[r:R]->(e) DELETE s,r RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void nestedShouldWorkGraph() {
        this.executeTransactionally("CREATE ()");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (n) DELETE (n) RETURN [n, {someKey: n}]"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedNodes(1));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void nestedShouldWorkRest() {
        this.executeTransactionally("CREATE ()");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (n) DELETE (n) RETURN [n, {someKey: n}]"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)commit, QueryResultsSerializationTest.restContainsNestedDeleted());
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void nestedShouldWorkRow() {
        this.executeTransactionally("CREATE ()");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (n) DELETE (n) RETURN [n, {someKey: n}]"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsDeletedEntities(2, 0));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldHandleTemporalArrays() throws Exception {
        GraphDatabaseFacade db = QueryResultsSerializationTest.server().getDatabaseService().getDatabase();
        ZonedDateTime date = ZonedDateTime.of(1980, 3, 11, 0, 0, 0, 0, ZoneId.of("Europe/Stockholm"));
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("date", (Object)new ZonedDateTime[]{date});
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", new String[0]);
        Assert.assertEquals((long)200L, (long)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("row").get(0).get("date").get(0);
        Assert.assertEquals((Object)"\"1980-03-11T00:00+01:00[Europe/Stockholm]\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleDurationArrays() throws Exception {
        GraphDatabaseFacade db = QueryResultsSerializationTest.server().getDatabaseService().getDatabase();
        Duration duration = Duration.ofSeconds(73L);
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("duration", (Object)new Duration[]{duration});
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", new String[0]);
        Assert.assertEquals((long)200L, (long)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("row").get(0).get("duration").get(0);
        Assert.assertEquals((Object)"\"PT1M13S\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleTemporalUsingRestResultDataContent() throws Exception {
        GraphDatabaseFacade db = QueryResultsSerializationTest.server().getDatabaseService().getDatabase();
        ZonedDateTime date = ZonedDateTime.of(1980, 3, 11, 0, 0, 0, 0, ZoneId.of("Europe/Stockholm"));
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("date", (Object)date);
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "rest");
        Assert.assertEquals((long)200L, (long)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("rest").get(0).get("data").get("date");
        Assert.assertEquals((Object)"\"1980-03-11T00:00+01:00[Europe/Stockholm]\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleDurationUsingRestResultDataContent() throws Exception {
        GraphDatabaseFacade db = QueryResultsSerializationTest.server().getDatabaseService().getDatabase();
        Duration duration = Duration.ofSeconds(73L);
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("duration", (Object)duration);
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "rest");
        Assert.assertEquals((long)200L, (long)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("rest").get(0).get("data").get("duration");
        Assert.assertEquals((Object)"\"PT1M13S\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleTemporalArraysUsingRestResultDataContent() throws Exception {
        GraphDatabaseFacade db = QueryResultsSerializationTest.server().getDatabaseService().getDatabase();
        ZonedDateTime date = ZonedDateTime.of(1980, 3, 11, 0, 0, 0, 0, ZoneId.of("Europe/Stockholm"));
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("dates", (Object)new ZonedDateTime[]{date});
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "rest");
        Assert.assertEquals((long)200L, (long)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("rest").get(0).get("data").get("dates").get(0);
        Assert.assertEquals((Object)"\"1980-03-11T00:00+01:00[Europe/Stockholm]\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleDurationArraysUsingRestResultDataContent() throws Exception {
        GraphDatabaseFacade db = QueryResultsSerializationTest.server().getDatabaseService().getDatabase();
        Duration duration = Duration.ofSeconds(73L);
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("durations", (Object)new Duration[]{duration});
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "rest");
        Assert.assertEquals((long)200L, (long)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("rest").get(0).get("data").get("durations").get(0);
        Assert.assertEquals((Object)"\"PT1M13S\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleTemporalUsingGraphResultDataContent() throws Exception {
        GraphDatabaseFacade db = QueryResultsSerializationTest.server().getDatabaseService().getDatabase();
        ZonedDateTime date = ZonedDateTime.of(1980, 3, 11, 0, 0, 0, 0, ZoneId.of("Europe/Stockholm"));
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("date", (Object)date);
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "graph");
        Assert.assertEquals((long)200L, (long)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("graph").get("nodes").get(0).get("properties").get("date");
        Assert.assertEquals((Object)"\"1980-03-11T00:00+01:00[Europe/Stockholm]\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleDurationUsingGraphResultDataContent() throws Exception {
        GraphDatabaseFacade db = QueryResultsSerializationTest.server().getDatabaseService().getDatabase();
        Duration duration = Duration.ofSeconds(73L);
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("duration", (Object)duration);
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "graph");
        Assert.assertEquals((long)200L, (long)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("graph").get("nodes").get(0).get("properties").get("duration");
        Assert.assertEquals((Object)"\"PT1M13S\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleTemporalArraysUsingGraphResultDataContent() throws Exception {
        GraphDatabaseFacade db = QueryResultsSerializationTest.server().getDatabaseService().getDatabase();
        ZonedDateTime date = ZonedDateTime.of(1980, 3, 11, 0, 0, 0, 0, ZoneId.of("Europe/Stockholm"));
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("dates", (Object)new ZonedDateTime[]{date});
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "graph");
        Assert.assertEquals((long)200L, (long)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("graph").get("nodes").get(0).get("properties").get("dates").get(0);
        Assert.assertEquals((Object)"\"1980-03-11T00:00+01:00[Europe/Stockholm]\"", (Object)row.toString());
    }

    @Test
    public void shouldHandleDurationArraysUsingGraphResultDataContent() throws Exception {
        GraphDatabaseFacade db = QueryResultsSerializationTest.server().getDatabaseService().getDatabase();
        Duration duration = Duration.ofSeconds(73L);
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"N")});
            node.setProperty("durations", (Object)new Duration[]{duration});
            tx.commit();
        }
        HTTP.Response response = QueryResultsSerializationTest.runQuery("MATCH (n:N) RETURN n", "graph");
        Assert.assertEquals((long)200L, (long)response.status());
        QueryResultsSerializationTest.assertNoErrors(response);
        JsonNode row = response.get("results").get(0).get("data").get(0).get("graph").get("nodes").get(0).get("properties").get("durations").get(0);
        Assert.assertEquals((Object)"\"PT1M13S\"", (Object)row.toString());
    }

    private HTTP.RawPayload queryAsJsonGraph(String query) {
        return HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': '" + query + "', 'resultDataContents': [ 'graph' ] } ] }");
    }

    private HTTP.RawPayload queryAsJsonRest(String query) {
        return HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': '" + query + "', 'resultDataContents': [ 'rest' ] } ] }");
    }

    private HTTP.RawPayload queryAsJsonRow(String query) {
        return HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': '" + query + "', 'resultDataContents': [ 'row' ] } ] }");
    }

    private long nodesInDatabase() {
        GraphDatabaseService database = this.graphdb();
        try (Transaction transaction = database.beginTx();){
            long l;
            block12: {
                Result r = transaction.execute("MATCH (n) RETURN count(n) AS c");
                try {
                    l = (Long)r.columnAs("c").next();
                    if (r == null) break block12;
                }
                catch (Throwable throwable) {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                r.close();
            }
            return l;
        }
    }

    private static Matcher<? super HTTP.Response> restContainsNestedDeleted() {
        return new TypeSafeMatcher<HTTP.Response>(){

            protected boolean matchesSafely(HTTP.Response response) {
                try {
                    JsonNode list = (JsonNode)TransactionMatchers.getJsonNodeWithName(response, "rest").iterator().next();
                    MatcherAssert.assertThat((Object)list.get(0).get("metadata").get("deleted").asBoolean(), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
                    MatcherAssert.assertThat((Object)list.get(1).get("someKey").get("metadata").get("deleted").asBoolean(), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
                    return true;
                }
                catch (JsonParseException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
            }
        };
    }
}

