/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.databind.JsonNode;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

public class TemporalTypeIT
extends AbstractRestFunctionalTestBase {
    @Test
    public void shouldWorkWithDateTime() throws Throwable {
        HTTP.Response response = TemporalTypeIT.runQuery("RETURN datetime({year: 1, month:10, day:2, timezone:\\\"+01:00\\\"})", new String[0]);
        Assert.assertEquals((long)200L, (long)response.status());
        TemporalTypeIT.assertNoErrors(response);
        JsonNode data = TemporalTypeIT.getSingleData(response);
        this.assertTemporalEquals(data, "0001-10-02T00:00+01:00", "datetime");
    }

    @Test
    public void shouldWorkWithTime() throws Throwable {
        HTTP.Response response = TemporalTypeIT.runQuery("RETURN time({hour: 23, minute: 19, second: 55, timezone:\\\"-07:00\\\"})", new String[0]);
        Assert.assertEquals((long)200L, (long)response.status());
        TemporalTypeIT.assertNoErrors(response);
        JsonNode data = TemporalTypeIT.getSingleData(response);
        this.assertTemporalEquals(data, "23:19:55-07:00", "time");
    }

    @Test
    public void shouldWorkWithLocalDateTime() throws Throwable {
        HTTP.Response response = TemporalTypeIT.runQuery("RETURN localdatetime({year: 1984, month: 10, day: 21, hour: 12, minute: 34})", new String[0]);
        Assert.assertEquals((long)200L, (long)response.status());
        TemporalTypeIT.assertNoErrors(response);
        JsonNode data = TemporalTypeIT.getSingleData(response);
        this.assertTemporalEquals(data, "1984-10-21T12:34", "localdatetime");
    }

    @Test
    public void shouldWorkWithDate() throws Throwable {
        HTTP.Response response = TemporalTypeIT.runQuery("RETURN date({year: 1984, month: 10, day: 11})", new String[0]);
        Assert.assertEquals((long)200L, (long)response.status());
        TemporalTypeIT.assertNoErrors(response);
        JsonNode data = TemporalTypeIT.getSingleData(response);
        this.assertTemporalEquals(data, "1984-10-11", "date");
    }

    @Test
    public void shouldWorkWithLocalTime() throws Throwable {
        HTTP.Response response = TemporalTypeIT.runQuery("RETURN localtime({hour:12, minute:31, second:14, nanosecond: 645876123})", new String[0]);
        Assert.assertEquals((long)200L, (long)response.status());
        TemporalTypeIT.assertNoErrors(response);
        JsonNode data = TemporalTypeIT.getSingleData(response);
        this.assertTemporalEquals(data, "12:31:14.645876123", "localtime");
    }

    @Test
    public void shouldWorkWithDuration() throws Throwable {
        HTTP.Response response = TemporalTypeIT.runQuery("RETURN duration({weeks:2, days:3})", new String[0]);
        Assert.assertEquals((long)200L, (long)response.status());
        TemporalTypeIT.assertNoErrors(response);
        JsonNode data = TemporalTypeIT.getSingleData(response);
        this.assertTemporalEquals(data, "P17D", "duration");
    }

    @Test
    public void shouldOnlyGetNodeTypeInMetaAsNodeProperties() throws Throwable {
        HTTP.Response response = TemporalTypeIT.runQuery("CREATE (account {name: \\\"zhen\\\", creationTime: localdatetime({year: 1984, month: 10, day: 21, hour: 12, minute: 34})}) RETURN account", new String[0]);
        Assert.assertEquals((long)200L, (long)response.status());
        TemporalTypeIT.assertNoErrors(response);
        JsonNode data = TemporalTypeIT.getSingleData(response);
        JsonNode row = TemporalTypeIT.getSingle(data, "row");
        MatcherAssert.assertThat((Object)row.get("creationTime").asText(), (Matcher)Matchers.equalTo((Object)"1984-10-21T12:34"));
        MatcherAssert.assertThat((Object)row.get("name").asText(), (Matcher)Matchers.equalTo((Object)"zhen"));
        JsonNode meta = TemporalTypeIT.getSingle(data, "meta");
        MatcherAssert.assertThat((Object)meta.get("type").asText(), (Matcher)Matchers.equalTo((Object)"node"));
    }

    private void assertTemporalEquals(JsonNode data, String value, String type) {
        JsonNode row = TemporalTypeIT.getSingle(data, "row");
        MatcherAssert.assertThat((Object)row.asText(), (Matcher)Matchers.equalTo((Object)value));
        JsonNode meta = TemporalTypeIT.getSingle(data, "meta");
        Assert.assertEquals((Object)type, (Object)meta.get("type").asText());
    }

    private static JsonNode getSingleData(HTTP.Response response) throws JsonParseException {
        JsonNode data = response.get("results").get(0).get("data");
        Assert.assertEquals((long)1L, (long)data.size());
        return data.get(0);
    }

    private static JsonNode getSingle(JsonNode node, String key) {
        JsonNode data = node.get(key);
        Assert.assertEquals((long)1L, (long)data.size());
        return data.get(0);
    }
}

