/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.http.cypher.integration.TransactionMatchers;
import org.neo4j.server.rest.ParameterizedTransactionEndpointsTestBase;
import org.neo4j.test.server.HTTP;

public class TransactionErrorIT
extends ParameterizedTransactionEndpointsTestBase {
    @Test
    public void begin__commit_with_invalid_cypher() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response response = this.POST(this.txUri, HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        String commitResource = response.stringFromContent("commit");
        response = this.POST(commitResource, HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE ;;' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Statement.SyntaxError}));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.containsNoStackTraces());
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)nodesInDatabaseBeforeTransaction));
    }

    @Test
    public void begin__commit_with_malformed_json() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.POST(this.txUri, HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response response = this.POST(commitResource, HTTP.RawPayload.rawPayload("[{asd,::}]"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Request.InvalidFormat}));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)nodesInDatabaseBeforeTransaction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void begin_and_execute_periodic_commit_that_fails() throws Exception {
        File file = File.createTempFile("begin_and_execute_periodic_commit_that_fails", ".csv").getAbsoluteFile();
        try {
            PrintStream out = new PrintStream(new FileOutputStream(file));
            out.println("1");
            out.println("2");
            out.println("0");
            out.println("3");
            out.close();
            String url = file.toURI().toURL().toString().replace("\\", "\\\\");
            String query = "USING PERIODIC COMMIT 1 LOAD CSV FROM \\\"" + url + "\\\" AS line CREATE ({name: 1/toInteger(line[0])});";
            HTTP.RawPayload payload = HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': '" + query + "' } ] }");
            HTTP.Response response = this.POST(this.txUri + "/commit", payload);
            MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Statement.ArithmeticError}));
            JsonNode message = response.get("errors").get(0).get("message");
            Assert.assertTrue((String)"Expected LOAD CSV line number information", (boolean)message.toString().contains("on line 3."));
        }
        finally {
            file.delete();
        }
    }

    private long countNodes() {
        return TransactionMatchers.countNodes(this.graphdb());
    }
}

