/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.http.cypher.integration.TransactionMatchers;
import org.neo4j.server.rest.ParameterizedTransactionEndpointsTestBase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.server.HTTP;

public class TransactionIT
extends ParameterizedTransactionEndpointsTestBase {
    private ExecutorService executors;

    @Before
    public void setUp() {
        this.executors = Executors.newFixedThreadPool(Math.max(3, Runtime.getRuntime().availableProcessors()));
    }

    @After
    public void tearDown() {
        this.executors.shutdown();
    }

    @Test
    public void begin__execute__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST(this.txUri);
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        TransactionIT.assertHasTxLocation(begin, this.txUri);
        String commitResource = begin.stringFromContent("commit");
        MatcherAssert.assertThat((Object)commitResource, TransactionMatchers.matches(String.format("http://localhost:\\d+/%s/\\d+/commit", this.txUri)));
        MatcherAssert.assertThat((Object)begin.get("transaction").get("expires").asText(), TransactionMatchers.isValidRFCTimestamp());
        HTTP.Response execute = this.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        MatcherAssert.assertThat((Object)execute.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)execute.get("transaction").get("expires").asText(), TransactionMatchers.isValidRFCTimestamp());
        HTTP.Response commit = this.POST(commitResource);
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(new String[0]), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin__execute__rollback() {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST(this.txUri);
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        TransactionIT.assertHasTxLocation(begin, this.txUri);
        this.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        HTTP.Response commit = this.DELETE(begin.location());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(new String[0]), (Matcher)CoreMatchers.equalTo((Object)nodesInDatabaseBeforeTransaction));
    }

    @Test
    public void begin__execute_and_commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST(this.txUri);
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        TransactionIT.assertHasTxLocation(begin, this.txUri);
        String commitResource = begin.stringFromContent("commit");
        MatcherAssert.assertThat((Object)commitResource, (Matcher)CoreMatchers.equalTo((Object)(begin.location() + "/commit")));
        HTTP.Response commit = this.POST(commitResource, HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(new String[0]), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin_and_execute__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST(this.txUri, HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response commit = this.POST(commitResource);
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(new String[0]), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin_and_execute__commit_with_badly_escaped_statement() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        String json = "{ \"statements\": [ { \"statement\": \"LOAD CSV WITH HEADERS FROM \\\"xx file://C:/countries.csvxxx\\\\\" as csvLine MERGE (c:Country { Code: csvLine.Code })\" } ] }";
        HTTP.Response begin = this.POST(this.txUri, HTTP.RawPayload.quotedJson(json));
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response commit = this.POST(commitResource);
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        MatcherAssert.assertThat((Object)begin, TransactionMatchers.hasErrors(new Status[]{Status.Request.InvalidFormat}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)404));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Transaction.TransactionNotFound}));
        MatcherAssert.assertThat((Object)this.countNodes(new String[0]), (Matcher)CoreMatchers.equalTo((Object)nodesInDatabaseBeforeTransaction));
    }

    @Test
    public void begin__execute__commit__execute() throws Exception {
        HTTP.Response begin = this.POST(this.txUri);
        String commitResource = begin.stringFromContent("commit");
        this.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        this.POST(commitResource);
        HTTP.Response execute2 = this.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        MatcherAssert.assertThat((Object)execute2.status(), (Matcher)CoreMatchers.equalTo((Object)404));
        MatcherAssert.assertThat((Object)execute2, TransactionMatchers.hasErrors(new Status[]{Status.Transaction.TransactionNotFound}));
    }

    @Test
    public void begin_and_execute_and_commit() {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)begin, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)this.countNodes(new String[0]), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin_and_execute_and_commit_with_badly_escaped_statement() {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        String json = "{ \"statements\": [ { \"statement\": \"LOAD CSV WITH HEADERS FROM \\\"xx file://C:/countries.csvxxx\\\\\" as csvLine MERGE (c:Country { Code: csvLine.Code })\" } ] }";
        HTTP.Response begin = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson(json));
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)begin, TransactionMatchers.hasErrors(new Status[]{Status.Request.InvalidFormat}));
        MatcherAssert.assertThat((Object)this.countNodes(new String[0]), (Matcher)CoreMatchers.equalTo((Object)nodesInDatabaseBeforeTransaction));
    }

    @Test
    public void begin_and_execute_periodic_commit_and_commit() throws Exception {
        int nodes = 11;
        int batch = 2;
        ServerTestUtils.withCSVFile(nodes, url -> {
            long txIdBefore;
            long nodesInDatabaseBeforeTransaction;
            HTTP.Response response;
            int times = 0;
            do {
                nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
                txIdBefore = this.resolveDependency(TransactionIdStore.class).getLastClosedTransactionId();
            } while ((response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'USING PERIODIC COMMIT " + batch + " LOAD CSV FROM \\\"" + url + "\\\" AS line CREATE ()' } ] }"))).get("errors").iterator().hasNext() && ++times < 5);
            long txIdAfter = this.resolveDependency(TransactionIdStore.class).getLastClosedTransactionId();
            MatcherAssert.assertThat((String)("Last response is: " + response), (Object)response, TransactionMatchers.containsNoErrors());
            MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.countNodes(new String[0]), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + (long)nodes)));
            MatcherAssert.assertThat((Object)txIdAfter, (Matcher)CoreMatchers.equalTo((Object)(txIdBefore + (long)(nodes / batch + 1))));
        });
    }

    @Test
    public void begin_and_execute_periodic_commit_that_returns_data_and_commit() throws Exception {
        int nodes = 11;
        int batchSize = 2;
        ServerTestUtils.withCSVFile(nodes, url -> {
            HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'USING PERIODIC COMMIT " + batchSize + " LOAD CSV FROM \\\"" + url + "\\\" AS line CREATE (n {id1: 23}) RETURN n' } ] }"));
        });
        ServerTestUtils.withCSVFile(nodes, url -> {
            long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
            long txIdBefore = this.resolveDependency(TransactionIdStore.class).getLastClosedTransactionId();
            HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'USING PERIODIC COMMIT " + batchSize + " LOAD CSV FROM \\\"" + url + "\\\" AS line CREATE (n {id1: 23}) RETURN n' } ] }"));
            long txIdAfter = this.resolveDependency(TransactionIdStore.class).getLastClosedTransactionId();
            MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response, TransactionMatchers.containsNoErrors());
            JsonNode columns = response.get("results").get(0).get("columns");
            MatcherAssert.assertThat((Object)columns.toString(), (Matcher)CoreMatchers.equalTo((Object)"[\"n\"]"));
            MatcherAssert.assertThat((Object)this.countNodes(new String[0]), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + (long)nodes)));
            long expectedTxCount = nodes / batchSize + 1;
            MatcherAssert.assertThat((Object)(txIdAfter - txIdBefore), (Matcher)CoreMatchers.equalTo((Object)expectedTxCount));
        });
    }

    @Test
    public void begin_and_execute_periodic_commit_followed_by_another_statement_and_commit() throws Exception {
        ServerTestUtils.withCSVFile(1, url -> {
            HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'USING PERIODIC COMMIT LOAD CSV FROM \\\"" + url + "\\\" AS line CREATE (n {id: 23}) RETURN n' }, { 'statement': 'RETURN 1' } ] }"));
            MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Statement.SemanticError}));
        });
    }

    @Test
    public void begin_and_execute_invalid_query_and_commit() {
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'MATCH n RETURN m' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Statement.SyntaxError}));
    }

    @Test
    public void begin_and_execute_multiple_periodic_commit_last_and_commit() throws Exception {
        ServerTestUtils.withCSVFile(1, url -> {
            HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE ()' }, { 'statement': 'USING PERIODIC COMMIT LOAD CSV FROM \\\"" + url + "\\\" AS line CREATE ()' } ] }"));
            MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Statement.SemanticError}));
        });
    }

    @Test
    public void begin__execute_multiple__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST(this.txUri);
        String commitResource = begin.stringFromContent("commit");
        this.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' }, { 'statement': 'CREATE (n)' } ] }"));
        HTTP.Response commit = this.POST(commitResource);
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)this.countNodes(new String[0]), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 2L)));
    }

    @Test
    public void begin__execute__execute__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST(this.txUri);
        String commitResource = begin.stringFromContent("commit");
        this.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        this.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        this.POST(commitResource);
        MatcherAssert.assertThat((Object)this.countNodes(new String[0]), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 2L)));
    }

    @Test
    public void begin_create_two_nodes_delete_one() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response response1 = this.POST(this.transactionCommitUri(), HTTP.RawPayload.rawPayload("{ \"statements\" : [{\"statement\" : \"CREATE (n0:DecibelEntity :AlbumGroup{DecibelID : '34a2201b-f4a9-420f-87ae-00a9c691cc5c', Title : 'Dance With Me', ArtistString : 'Ra Ra Riot', MainArtistAlias : 'Ra Ra Riot', OriginalReleaseDate : '2013-01-08', IsCanon : 'False'}) return id(n0)\"}, {\"statement\" : \"CREATE (n1:DecibelEntity :AlbumRelease{DecibelID : '9ed529fa-7c19-11e2-be78-bcaec5bea3c3', Title : 'Dance With Me', ArtistString : 'Ra Ra Riot', MainArtistAlias : 'Ra Ra Riot', LabelName : 'Barsuk Records', FormatNames : 'File', TrackCount : '3', MediaCount : '1', Duration : '460.000000', ReleaseDate : '2013-01-08', ReleaseYear : '2013', ReleaseRegion : 'USA', Cline : 'Barsuk Records', Pline : 'Barsuk Records', CYear : '2013', PYear : '2013', ParentalAdvisory : 'False', IsLimitedEdition : 'False'}) return id(n1)\"}]}"));
        Assert.assertEquals((long)200L, (long)response1.status());
        JsonNode everything = JsonHelper.jsonNode((String)response1.rawContent());
        JsonNode result = everything.get("results").get(0);
        long id = result.get("data").get(0).get("row").get(0).asLong();
        HTTP.Response response2 = this.POST(this.transactionCommitUri(), HTTP.RawPayload.rawPayload("{ \"statements\" : [{\"statement\":\"match (n) where id(n) = " + id + " delete n\"}]}"));
        Assert.assertEquals((long)200L, (long)response2.status());
        MatcherAssert.assertThat((Object)this.countNodes(new String[0]), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin__rollback__commit() throws Exception {
        HTTP.Response begin = this.POST(this.txUri);
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        TransactionIT.assertHasTxLocation(begin, this.txUri);
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response interrupt = this.DELETE(begin.location());
        MatcherAssert.assertThat((Object)interrupt.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        HTTP.Response commit = this.POST(commitResource);
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)404));
    }

    @Test
    public void begin__rollback__execute() {
        HTTP.Response begin = this.POST(this.txUri);
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        TransactionIT.assertHasTxLocation(begin, this.txUri);
        HTTP.Response interrupt = this.DELETE(begin.location());
        MatcherAssert.assertThat((Object)interrupt.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        HTTP.Response execute = this.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        MatcherAssert.assertThat((Object)execute.status(), (Matcher)CoreMatchers.equalTo((Object)404));
    }

    @Test(timeout=30000L)
    public void begin__execute__rollback_concurrently() throws Exception {
        HTTP.Response begin = this.POST(this.txUri);
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        TransactionIT.assertHasTxLocation(begin, this.txUri);
        Label sharedLockLabel = Label.label((String)"sharedLock");
        this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n:" + sharedLockLabel + ")' } ] }"));
        CountDownLatch nodeLockLatch = new CountDownLatch(1);
        CountDownLatch nodeReleaseLatch = new CountDownLatch(1);
        Future<?> lockerFuture = this.executors.submit(() -> this.lockNodeWithLabel(sharedLockLabel, nodeLockLatch, nodeReleaseLatch));
        nodeLockLatch.await();
        String executeResource = begin.location();
        String statement = "MATCH (n:" + sharedLockLabel + ") DELETE n RETURN count(n)";
        Future<HTTP.Response> executeFuture = this.executors.submit(() -> {
            HTTP.Builder requestBuilder = HTTP.withBaseUri(TransactionIT.server().baseUri());
            HTTP.Response response = requestBuilder.POST(executeResource, HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': '" + statement + "' } ] }"));
            MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
            return response;
        });
        Future<HTTP.Response> interruptFuture = this.executors.submit(() -> {
            TransactionIT.waitForStatementExecution(statement);
            HTTP.Response response = this.DELETE(executeResource);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
            nodeReleaseLatch.countDown();
            return response;
        });
        interruptFuture.get();
        lockerFuture.get();
        HTTP.Response execute = executeFuture.get();
        MatcherAssert.assertThat((Object)execute, TransactionMatchers.hasErrors(new Status[]{Status.Statement.ExecutionFailed}));
        HTTP.Response execute2 = this.POST(executeResource, HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        MatcherAssert.assertThat((Object)execute2.status(), (Matcher)CoreMatchers.equalTo((Object)404));
        MatcherAssert.assertThat((Object)execute2, TransactionMatchers.hasErrors(new Status[]{Status.Transaction.TransactionNotFound}));
    }

    @Test
    public void status_codes_should_appear_in_response() {
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'RETURN $n' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response, TransactionMatchers.hasErrors(new Status[]{Status.Statement.ParameterMissing}));
    }

    @Test
    public void should_return_location_correctly_in_response() throws JsonParseException {
        HTTP.Response begin = this.POST(this.txUri);
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        TransactionIT.assertHasTxLocation(begin, this.txUri);
        long txId = TransactionIT.extractTxId(begin);
        HTTP.Response response = this.POST(String.format("%s/%s", this.txUri, txId), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'RETURN 1' } ] }"));
        System.out.println(response);
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.get("commit").toString(), (Matcher)CoreMatchers.containsString((String)this.txUri));
        HTTP.Response commit = this.POST(String.format("%s/%s/commit", this.txUri, txId));
        System.out.println(commit);
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)commit.get("commit").toString(), (Matcher)CoreMatchers.containsString((String)this.txUri));
    }

    @Test(timeout=30000L)
    public void executing_single_statement_in_new_transaction_and_failing_to_read_the_output_should_interrupt() throws Exception {
        long additionalRollBacks;
        long initialNodes = this.countNodes(new String[0]);
        DatabaseTransactionStats txMonitor = (DatabaseTransactionStats)((GraphDatabaseAPI)this.graphdb()).getDependencyResolver().resolveDependency(DatabaseTransactionStats.class);
        long initialRollBacks = txMonitor.getNumberOfRolledBackTransactions();
        Socket socket = new Socket("localhost", TransactionIT.getLocalHttpPort());
        PrintStream out = new PrintStream(socket.getOutputStream());
        String output = HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'UNWIND range(0, 9999) AS i CREATE (n {i: i}) RETURN n' } ] }").get();
        out.print(String.format("POST /%s/commit HTTP/1.1\r\n", this.txUri));
        out.print("Host: localhost:7474\r\n");
        out.print("Content-type: application/json; charset=utf-8\r\n");
        out.print("Content-length: " + output.getBytes().length + "\r\n");
        out.print("\r\n");
        out.print(output);
        out.print("\r\n");
        InputStream inputStream = socket.getInputStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        for (int numRead = 0; numRead < 300; numRead += reader.read(new char[300])) {
        }
        socket.close();
        Assert.assertEquals((long)initialNodes, (long)this.countNodes(new String[0]));
        long endTime = System.currentTimeMillis() + 5000L;
        while ((additionalRollBacks = txMonitor.getNumberOfRolledBackTransactions() - initialRollBacks) <= 0L && System.currentTimeMillis() <= endTime) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)additionalRollBacks);
    }

    @Test
    public void should_include_graph_format_when_requested() throws Exception {
        long initialData = this.countNodes("Foo");
        this.POST(this.transactionCommitUri(), TransactionIT.singleStatement("CREATE (n:Foo:Bar)"));
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'MATCH (n:Foo) RETURN n', 'resultDataContents':['row','graph'] } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        JsonNode data = response.get("results").get(0).get("data");
        Assert.assertTrue((String)"data is a list", (boolean)data.isArray());
        Assert.assertEquals((String)"one entry", (long)(initialData + 1L), (long)data.size());
        JsonNode entry = data.get(0);
        Assert.assertTrue((String)"entry has row", (boolean)entry.has("row"));
        Assert.assertTrue((String)"entry has graph", (boolean)entry.has("graph"));
        JsonNode nodes = entry.get("graph").get("nodes");
        JsonNode rels = entry.get("graph").get("relationships");
        Assert.assertTrue((String)"nodes is a list", (boolean)nodes.isArray());
        Assert.assertTrue((String)"relationships is a list", (boolean)rels.isArray());
        Assert.assertEquals((String)"one node", (long)1L, (long)nodes.size());
        Assert.assertEquals((String)"no relationships", (long)0L, (long)rels.size());
        HashSet<String> labels = new HashSet<String>();
        for (JsonNode node : nodes.get(0).get("labels")) {
            labels.add(node.asText());
        }
        Assert.assertTrue((String)"some labels", (labels.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void should_serialize_collect_correctly() throws Exception {
        this.POST(this.transactionCommitUri(), TransactionIT.singleStatement("CREATE (n:Foo)"));
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'MATCH (n:Foo) RETURN COLLECT(n)' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        JsonNode data = response.get("results").get(0);
        MatcherAssert.assertThat((Object)data.get("columns").get(0).asText(), (Matcher)CoreMatchers.equalTo((Object)"COLLECT(n)"));
        MatcherAssert.assertThat((Object)data.get("data").get(0).get("row").size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)data.get("data").get(0).get("row").get(0).get(0).size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)response.get("errors").size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldSerializeMapsCorrectlyInRowsFormat() throws Exception {
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'RETURN {one:{two:[true, {three: 42}]}}' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        JsonNode data = response.get("results").get(0);
        JsonNode row = data.get("data").get(0).get("row");
        MatcherAssert.assertThat((Object)row.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        JsonNode firstCell = row.get(0);
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").get(0).asBoolean(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").get(1).get("three").asInt(), (Matcher)CoreMatchers.is((Object)42));
        MatcherAssert.assertThat((Object)response.get("errors").size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldSerializeMapsCorrectlyInRestFormat() throws Exception {
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'RETURN {one:{two:[true, {three: 42}]}}', 'resultDataContents':['rest'] } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        JsonNode data = response.get("results").get(0);
        JsonNode rest = data.get("data").get(0).get("rest");
        MatcherAssert.assertThat((Object)rest.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        JsonNode firstCell = rest.get(0);
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").get(0).asBoolean(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)firstCell.get("one").get("two").get(1).get("three").asInt(), (Matcher)CoreMatchers.is((Object)42));
        MatcherAssert.assertThat((Object)response.get("errors").size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldHandleMapParametersCorrectly() throws Exception {
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'WITH $map AS map RETURN map[0]', 'parameters':{'map':[{'index':0,'name':'a'},{'index':1,'name':'b'}]} } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        JsonNode data = response.get("results").get(0);
        JsonNode row = data.get("data").get(0).get("row");
        MatcherAssert.assertThat((Object)row.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)row.get(0).get("index").asInt(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)row.get(0).get("name").asText(), (Matcher)CoreMatchers.equalTo((Object)"a"));
        MatcherAssert.assertThat((Object)response.get("errors").size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void restFormatNodesShouldHaveSensibleUris() throws Throwable {
        String hostname = "localhost";
        HTTP.Response rs = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n:Foo:Bar) RETURN n', 'resultDataContents':['rest'] } ] }"));
        JsonNode restNode = rs.get("results").get(0).get("data").get(0).get("rest").get(0);
        this.assertPath(restNode.get("labels"), "/node/\\d+/labels", "localhost");
        this.assertPath(restNode.get("outgoing_relationships"), "/node/\\d+/relationships/out", "localhost");
        this.assertPath(restNode.get("traverse"), "/node/\\d+/traverse/\\{returnType\\}", "localhost");
        this.assertPath(restNode.get("all_typed_relationships"), "/node/\\d+/relationships/all/\\{-list\\|&\\|types\\}", "localhost");
        this.assertPath(restNode.get("self"), "/node/\\d+", "localhost");
        this.assertPath(restNode.get("property"), "/node/\\d+/properties/\\{key\\}", "localhost");
        this.assertPath(restNode.get("properties"), "/node/\\d+/properties", "localhost");
        this.assertPath(restNode.get("outgoing_typed_relationships"), "/node/\\d+/relationships/out/\\{-list\\|&\\|types\\}", "localhost");
        this.assertPath(restNode.get("incoming_relationships"), "/node/\\d+/relationships/in", "localhost");
        this.assertPath(restNode.get("create_relationship"), "/node/\\d+/relationships", "localhost");
        this.assertPath(restNode.get("paged_traverse"), "/node/\\d+/paged/traverse/\\{returnType\\}\\{\\?pageSize,leaseTime\\}", "localhost");
        this.assertPath(restNode.get("all_relationships"), "/node/\\d+/relationships/all", "localhost");
        this.assertPath(restNode.get("incoming_typed_relationships"), "/node/\\d+/relationships/in/\\{-list\\|&\\|types\\}", "localhost");
    }

    @Test
    public void restFormattedNodesShouldHaveSensibleUrisWhenUsingXForwardHeader() throws Throwable {
        String hostname = "dummy.example.org";
        HTTP.Response rs = this.http.withHeaders("X-Forwarded-Host", "dummy.example.org").POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE (n:Foo:Bar) RETURN n', 'resultDataContents':['rest'] } ] }"));
        JsonNode restNode = rs.get("results").get(0).get("data").get(0).get("rest").get(0);
        this.assertPath(restNode.get("labels"), "/node/\\d+/labels", "dummy.example.org");
        this.assertPath(restNode.get("outgoing_relationships"), "/node/\\d+/relationships/out", "dummy.example.org");
        this.assertPath(restNode.get("traverse"), "/node/\\d+/traverse/\\{returnType\\}", "dummy.example.org");
        this.assertPath(restNode.get("all_typed_relationships"), "/node/\\d+/relationships/all/\\{-list\\|&\\|types\\}", "dummy.example.org");
        this.assertPath(restNode.get("self"), "/node/\\d+", "dummy.example.org");
        this.assertPath(restNode.get("property"), "/node/\\d+/properties/\\{key\\}", "dummy.example.org");
        this.assertPath(restNode.get("properties"), "/node/\\d+/properties", "dummy.example.org");
        this.assertPath(restNode.get("outgoing_typed_relationships"), "/node/\\d+/relationships/out/\\{-list\\|&\\|types\\}", "dummy.example.org");
        this.assertPath(restNode.get("incoming_relationships"), "/node/\\d+/relationships/in", "dummy.example.org");
        this.assertPath(restNode.get("create_relationship"), "/node/\\d+/relationships", "dummy.example.org");
        this.assertPath(restNode.get("paged_traverse"), "/node/\\d+/paged/traverse/\\{returnType\\}\\{\\?pageSize,leaseTime\\}", "dummy.example.org");
        this.assertPath(restNode.get("all_relationships"), "/node/\\d+/relationships/all", "dummy.example.org");
        this.assertPath(restNode.get("incoming_typed_relationships"), "/node/\\d+/relationships/in/\\{-list\\|&\\|types\\}", "dummy.example.org");
    }

    @Test
    public void correctStatusCodeWhenUsingHintWithoutAnyIndex() {
        HTTP.Response begin = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'MATCH (n:Test) USING INDEX n:Test(foo) WHERE n.foo = 42 RETURN n.foo' } ] }"));
        MatcherAssert.assertThat((Object)begin, TransactionMatchers.hasErrors(new Status[]{Status.Schema.IndexNotFound}));
    }

    @Test
    public void transaction_not_in_response_on_failure() throws Exception {
        HTTP.Response begin = this.POST(this.txUri);
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response valid = this.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'RETURN 42' } ] }"));
        MatcherAssert.assertThat((Object)valid.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)valid.get("transaction"), (Matcher)CoreMatchers.notNullValue());
        HTTP.Response invalid = this.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'RETRUN 42' } ] }"));
        MatcherAssert.assertThat((Object)invalid.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)invalid.get("transaction"), (Matcher)CoreMatchers.nullValue());
        HTTP.Response commit = this.POST(commitResource);
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)404));
    }

    @Test
    public void shouldWorkWhenHittingTheASTCacheInCypher() throws JsonParseException {
        HTTP.Response response = this.POST(this.transactionCommitUri(), TransactionIT.singleStatement("MATCH (group:Group {name: \\\"AAA\\\"}) RETURN *"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.get("errors").size(), (Matcher)CoreMatchers.equalTo((Object)0));
        response = this.POST(this.transactionCommitUri(), TransactionIT.singleStatement("MATCH (group:Group {name: \\\"BBB\\\"}) RETURN *"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.get("errors").size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    private String transactionCommitUri() {
        return String.format("%s/commit", this.txUri);
    }

    private String databaseName() {
        return this.txUri.split("/")[1];
    }

    private void assertPath(JsonNode jsonURIString, String path, String hostname) {
        String databaseName = this.databaseName();
        String expected = String.format("http://%s:\\d+/db/%s%s", hostname, databaseName, path);
        Assert.assertTrue((String)String.format("Expected a uri matching '%s', but got '%s'.", expected, jsonURIString.asText()), (boolean)jsonURIString.asText().matches(expected));
    }

    private static HTTP.RawPayload singleStatement(String statement) {
        return HTTP.RawPayload.rawPayload("{\"statements\":[{\"statement\":\"" + statement + "\"}]}");
    }

    private long countNodes(String ... labels) {
        HashSet<Label> givenLabels = new HashSet<Label>(labels.length);
        for (String label : labels) {
            givenLabels.add(Label.label((String)label));
        }
        GraphDatabaseService graphdb = this.graphdb();
        try (Transaction transaction = graphdb.beginTx();){
            long count = 0L;
            for (Node node : transaction.getAllNodes()) {
                Set nodeLabels = Iterables.asSet((Iterable)node.getLabels());
                if (!nodeLabels.containsAll(givenLabels)) continue;
                ++count;
            }
            transaction.commit();
            long l = count;
            return l;
        }
    }

    private void lockNodeWithLabel(Label sharedLockLabel, CountDownLatch nodeLockLatch, CountDownLatch nodeReleaseLatch) {
        GraphDatabaseService db = this.graphdb();
        try (Transaction tx = db.beginTx();
             ResourceIterator nodes = tx.findNodes(sharedLockLabel);){
            Node node = (Node)nodes.next();
            node.setProperty("a", (Object)"b");
            nodeLockLatch.countDown();
            nodeReleaseLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void waitForStatementExecution(String statement) {
        KernelTransactions kernelTransactions = (KernelTransactions)TransactionIT.server().getDatabaseService().getDatabase().getDependencyResolver().resolveDependency(KernelTransactions.class);
        while (!TransactionIT.isStatementExecuting(kernelTransactions, statement)) {
            Thread.yield();
        }
    }

    private static boolean isStatementExecuting(KernelTransactions kernelTransactions, String statement) {
        return kernelTransactions.activeTransactions().stream().flatMap(k -> k.executingQuery().stream()).anyMatch(executingQuery -> statement.equals(executingQuery.queryText()));
    }
}

