/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;

public class ConfigureBaseUriIT
extends AbstractRestFunctionalTestBase {
    private static FunctionalTestHelper functionalTestHelper;
    private static HttpClient httpClient;

    @BeforeClass
    public static void setupServer() {
        functionalTestHelper = new FunctionalTestHelper(ConfigureBaseUriIT.server());
        httpClient = HttpClient.newHttpClient();
    }

    @Test
    public void shouldForwardHttpAndHost() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().header("Accept", "application/json").header("X-Forwarded-Host", "foobar.com").header("X-Forwarded-Proto", "http").build();
        HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        ConfigureBaseUriIT.verifyContentLength(response);
        String responseBodyString = new String(response.body());
        MatcherAssert.assertThat((Object)responseBodyString, (Matcher)Matchers.containsString((String)"http://foobar.com"));
        MatcherAssert.assertThat((Object)responseBodyString, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"http://localhost")));
    }

    @Test
    public void shouldForwardHttpsAndHost() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().header("Accept", "application/json").header("X-Forwarded-Host", "foobar.com").header("X-Forwarded-Proto", "https").build();
        HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        ConfigureBaseUriIT.verifyContentLength(response);
        String responseBodyString = new String(response.body());
        MatcherAssert.assertThat((Object)responseBodyString, (Matcher)Matchers.containsString((String)"https://foobar.com"));
        MatcherAssert.assertThat((Object)responseBodyString, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"https://localhost")));
    }

    @Test
    public void shouldForwardHttpAndHostOnDifferentPort() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().header("Accept", "application/json").header("X-Forwarded-Host", "foobar.com:9999").header("X-Forwarded-Proto", "http").build();
        HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        ConfigureBaseUriIT.verifyContentLength(response);
        String responseBodyString = new String(response.body());
        MatcherAssert.assertThat((Object)responseBodyString, (Matcher)Matchers.containsString((String)"http://foobar.com:9999"));
        MatcherAssert.assertThat((Object)responseBodyString, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"http://localhost")));
    }

    @Test
    public void shouldForwardHttpAndFirstHost() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().header("Accept", "application/json").header("X-Forwarded-Host", "foobar.com, bazbar.com").header("X-Forwarded-Proto", "http").build();
        HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        ConfigureBaseUriIT.verifyContentLength(response);
        String responseBodyString = new String(response.body());
        MatcherAssert.assertThat((Object)responseBodyString, (Matcher)Matchers.containsString((String)"http://foobar.com"));
        MatcherAssert.assertThat((Object)responseBodyString, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"http://localhost")));
    }

    @Test
    public void shouldForwardHttpsAndHostOnDifferentPort() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().header("Accept", "application/json").header("X-Forwarded-Host", "foobar.com:9999").header("X-Forwarded-Proto", "https").build();
        HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        ConfigureBaseUriIT.verifyContentLength(response);
        String responseBodyString = new String(response.body());
        MatcherAssert.assertThat((Object)responseBodyString, (Matcher)Matchers.containsString((String)"https://foobar.com:9999"));
        MatcherAssert.assertThat((Object)responseBodyString, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"https://localhost")));
    }

    @Test
    public void shouldUseRequestUriWhenNoXForwardHeadersPresent() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().header("Accept", "application/json").build();
        HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        ConfigureBaseUriIT.verifyContentLength(response);
        String responseBodyString = new String(response.body());
        MatcherAssert.assertThat((Object)responseBodyString, (Matcher)Matchers.containsString((String)"http://localhost"));
        MatcherAssert.assertThat((Object)responseBodyString, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"https://foobar.com")));
        MatcherAssert.assertThat((Object)responseBodyString, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)":0")));
    }

    private static void verifyContentLength(HttpResponse<byte[]> response) {
        Optional<String> contentLengthValue = response.headers().firstValue("CONTENT-LENGTH");
        Assert.assertTrue((boolean)contentLengthValue.isPresent());
        Assert.assertEquals((long)Integer.parseInt(contentLengthValue.get()), (long)response.body().length);
    }
}

