/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.discovery.CommunityDiscoverableURIs;
import org.neo4j.server.rest.discovery.DiscoveryService;
import org.neo4j.server.rest.discovery.ServerVersionAndEdition;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.test.server.EntityOutputFormat;

@RunWith(value=Parameterized.class)
public class DiscoveryServiceTest {
    private final NeoServer neoServer = (NeoServer)Mockito.mock(NeoServer.class, (Answer)Answers.RETURNS_DEEP_STUBS);
    private final ConnectorPortRegister portRegistry = (ConnectorPortRegister)Mockito.mock(ConnectorPortRegister.class);
    private URI baseUri;
    private URI dbUri;
    private Consumer<ConnectorPortRegister> portRegistryOverrider;
    private Consumer<Config.Builder> configOverrider;
    private String expectedDatabaseUri;
    private String expectedBoltUri;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> cases = new ArrayList<Object[]>();
        cases.add(new Object[]{"http://localhost:7474", "http://localhost:7474", null, null, "bolt://localhost:7687"});
        cases.add(new Object[]{"https://localhost:7473", "https://localhost:7473", null, null, "bolt://localhost:7687"});
        cases.add(new Object[]{"http://www.example.com", "http://www.example.com", null, null, "bolt://www.example.com:7687"});
        cases.add(new Object[]{"http://localhost:7474 - 0.0.0.0", "http://localhost:7474", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("0.0.0.0"), "bolt://localhost:7687"});
        cases.add(new Object[]{"https://localhost:7473 - 0.0.0.0", "https://localhost:7473", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("0.0.0.0"), "bolt://localhost:7687"});
        cases.add(new Object[]{"http://www.example.com - 0.0.0.0", "http://www.example.com", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("0.0.0.0"), "bolt://www.example.com:7687"});
        cases.add(new Object[]{"http://localhost:7474 - ::", "http://localhost:7474", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), "bolt://localhost:7687"});
        cases.add(new Object[]{"https://localhost:7473 - ::", "https://localhost:7473", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), "bolt://localhost:7687"});
        cases.add(new Object[]{"http://www.example.com - ::", "http://www.example.com", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), "bolt://www.example.com:7687"});
        cases.add(new Object[]{"http://localhost:7474 - [::]:8888", "http://localhost:7474", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), DiscoveryServiceTest.overrideWithListenAddress("::", 8888)), "bolt://localhost:8888"});
        cases.add(new Object[]{"https://localhost:7473 - [::]:8888", "https://localhost:7473", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), DiscoveryServiceTest.overrideWithListenAddress("::", 8888)), "bolt://localhost:8888"});
        cases.add(new Object[]{"http://www.example.com - [::]:8888", "http://www.example.com", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), DiscoveryServiceTest.overrideWithListenAddress("::", 8888)), "bolt://www.example.com:8888"});
        cases.add(new Object[]{"http://www.example.com (advertised 1)", "http://www.example.com", null, DiscoveryServiceTest.overrideWithAdvertisedAddress("www.example.com", 8898), "bolt://www.example.com:8898"});
        cases.add(new Object[]{"http://www.example.com (advertised 2)", "http://www.example.com", null, DiscoveryServiceTest.overrideWithAdvertisedAddress("www2.example.com", 7576), "bolt://www2.example.com:7576"});
        cases.add(new Object[]{"http://www.example.com (advertised 3)", "http://www.example.com", DiscoveryServiceTest.register("bolt", "localhost", 9999), DiscoveryServiceTest.overrideWithAdvertisedAddress("www2.example.com", 0), "bolt://www2.example.com:9999"});
        cases.add(new Object[]{"http://www.example.com (discoverable 1)", "http://www.example.com", null, DiscoveryServiceTest.overrideWithDiscoverable("bolt://www.notanexample.com:7777"), "bolt://www.notanexample.com:7777"});
        cases.add(new Object[]{"http://www.example.com (discoverable 2)", "http://www.example.com", null, DiscoveryServiceTest.overrideWithDiscoverable("something://www.notanexample.com:7777"), "something://www.notanexample.com:7777"});
        cases.add(new Object[]{"http://www.example.com (discoverable and advertised 1)", "http://www.example.com", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithDiscoverable("bolt://www.notanexample.com:7777"), DiscoveryServiceTest.overrideWithAdvertisedAddress("www.notanexample2.com", 8888)), "bolt://www.notanexample.com:7777"});
        cases.add(new Object[]{"http://www.example.com (discoverable and advertised 2)", "http://www.example.com", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithAdvertisedAddress("www.notanexample2.com", 8888), DiscoveryServiceTest.overrideWithDiscoverable("bolt://www.notanexample.com:7777")), "bolt://www.notanexample.com:7777"});
        return cases;
    }

    public DiscoveryServiceTest(String description, String baseUri, Consumer<ConnectorPortRegister> portRegistryOverrider, Consumer<Config.Builder> configOverrider, String expectedBoltUri) throws Throwable {
        this.baseUri = new URI(baseUri);
        this.dbUri = new URI("/db");
        this.portRegistryOverrider = portRegistryOverrider;
        this.configOverrider = configOverrider;
        this.expectedDatabaseUri = this.baseUri.resolve(this.dbUri).toString();
        this.expectedBoltUri = expectedBoltUri;
    }

    @Before
    public void setUp() {
        if (this.portRegistryOverrider != null) {
            this.portRegistryOverrider.accept(this.portRegistry);
        } else {
            Mockito.when((Object)this.portRegistry.getLocalAddress("bolt")).thenReturn((Object)new HostnamePort("localhost", 7687));
        }
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)((ConnectorPortRegister)dependencyResolver.resolveDependency(ConnectorPortRegister.class))).thenReturn((Object)this.portRegistry);
        Mockito.when((Object)this.neoServer.getDatabaseService().getDatabase().getDependencyResolver()).thenReturn((Object)dependencyResolver);
    }

    private Config mockConfig() {
        Config.Builder builder = Config.newBuilder().set(GraphDatabaseSettings.auth_enabled, (Object)false).set(BoltConnector.enabled, (Object)true).set(ServerSettings.db_api_path, (Object)this.dbUri);
        if (this.configOverrider != null) {
            this.configOverrider.accept(builder);
        }
        return builder.build();
    }

    private DiscoveryService testDiscoveryService() {
        Config config = this.mockConfig();
        return new DiscoveryService(config, (OutputFormat)new EntityOutputFormat((RepresentationFormat)new JsonFormat(), this.baseUri), CommunityDiscoverableURIs.communityDiscoverableURIs((Config)config, (ConnectorPortRegister)this.portRegistry), (ServerVersionAndEdition)Mockito.mock(ServerVersionAndEdition.class));
    }

    @Test
    public void shouldReturnValidJSON() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo(this.baseUri));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"\"\"")));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"null")));
    }

    private UriInfo uriInfo(URI baseUri) {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getBaseUri()).thenReturn((Object)baseUri);
        return uriInfo;
    }

    @Test
    public void shouldReturnBoltDirectURI() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo(this.baseUri));
        String json = new String((byte[])response.getEntity());
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"bolt_direct\" : \"" + this.expectedBoltUri)));
    }

    @Test
    public void shouldReturnTxURI() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo(this.baseUri));
        String json = new String((byte[])response.getEntity());
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"transaction\" : \"" + this.expectedDatabaseUri + "/")));
    }

    @Test
    public void shouldNotReturnManagementURI() throws Exception {
        Response response = this.testDiscoveryService().getDiscoveryDocument(this.uriInfo(this.baseUri));
        String json = new String((byte[])response.getEntity());
        Assert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"\"management\"")));
    }

    @Test
    public void shouldReturnRedirectToAbsoluteAPIUsingOutputFormat() throws Exception {
        Config config = Config.defaults((Setting)ServerSettings.browser_path, (Object)URI.create("/browser/"));
        String baseUri = "http://www.example.com:5435";
        DiscoveryService ds = new DiscoveryService(config, (OutputFormat)new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI(baseUri)), CommunityDiscoverableURIs.communityDiscoverableURIs((Config)config, null), (ServerVersionAndEdition)Mockito.mock(ServerVersionAndEdition.class));
        Response response = ds.redirectToBrowser();
        Assert.assertThat((Object)response.getMetadata().getFirst((Object)"Location"), (Matcher)Matchers.is((Object)new URI("http://www.example.com:5435/browser/")));
    }

    private static Consumer<ConnectorPortRegister> register(String connector, String host, int port) {
        return register -> Mockito.when((Object)register.getLocalAddress(connector)).thenReturn((Object)new HostnamePort(host, port));
    }

    private static Consumer<Config.Builder> overrideWithAdvertisedAddress(String host, int port) {
        return builder -> builder.set(BoltConnector.advertised_address, (Object)new SocketAddress(host, port));
    }

    private static Consumer<Config.Builder> overrideWithListenAddress(String host, int port) {
        return builder -> {
            builder.set(BoltConnector.listen_address, (Object)new SocketAddress(host, port));
            builder.setDefault(BoltConnector.advertised_address, (Object)new SocketAddress(port));
        };
    }

    private static Consumer<Config.Builder> overrideWithDefaultListenAddress(String host) {
        return builder -> builder.set(GraphDatabaseSettings.default_listen_address, (Object)new SocketAddress(host));
    }

    private static Consumer<Config.Builder> overrideWithDiscoverable(String uri) {
        return builder -> builder.set(ServerSettings.bolt_discoverable_address, (Object)URI.create(uri));
    }

    @SafeVarargs
    private static Consumer<Config.Builder> combineConfigOverriders(Consumer<Config.Builder> ... overriders) {
        return config -> {
            for (Consumer overrider : overriders) {
                overrider.accept(config);
            }
        };
    }
}

