/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.IterableWrapper;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.server.database.DatabaseService;

public class GraphDbHelper {
    private final DatabaseService database;

    public GraphDbHelper(DatabaseService database) {
        this.database = database;
    }

    public int getNumberOfNodes() {
        int n;
        block8: {
            Kernel kernel = (Kernel)this.database.getDatabase().getDependencyResolver().resolveDependency(Kernel.class);
            KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.read());
            try {
                n = Math.toIntExact(tx.dataRead().nodesGetCount());
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TransactionFailureException e) {
                    throw new RuntimeException(e);
                }
            }
            tx.close();
        }
        return n;
    }

    public int getNumberOfRelationships() {
        int n;
        block8: {
            Kernel kernel = (Kernel)this.database.getDatabase().getDependencyResolver().resolveDependency(Kernel.class);
            KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.read());
            try {
                n = Math.toIntExact(tx.dataRead().relationshipsGetCount());
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TransactionFailureException e) {
                    throw new RuntimeException(e);
                }
            }
            tx.close();
        }
        return n;
    }

    public Map<String, Object> getNodeProperties(long nodeId) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.read());){
            Node node = tx.getNodeById(nodeId);
            Map allProperties = node.getAllProperties();
            tx.commit();
            Map map = allProperties;
            return map;
        }
    }

    public void setNodeProperties(long nodeId, Map<String, Object> properties) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.writeToken());){
            Node node = tx.getNodeById(nodeId);
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                node.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            tx.commit();
        }
    }

    public long createNode(Label ... labels) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.writeToken());){
            Node node = tx.createNode(labels);
            tx.commit();
            long l = node.getId();
            return l;
        }
    }

    public long createNode(Map<String, Object> properties, Label ... labels) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.writeToken());){
            Node node = tx.createNode(labels);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                node.setProperty(entry.getKey(), entry.getValue());
            }
            tx.commit();
            long l = node.getId();
            return l;
        }
    }

    public void deleteNode(long id) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.write());){
            Node node = tx.getNodeById(id);
            node.delete();
            tx.commit();
        }
    }

    public long createRelationship(String type, long startNodeId, long endNodeId) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.writeToken());){
            Node startNode = tx.getNodeById(startNodeId);
            Node endNode = tx.getNodeById(endNodeId);
            Relationship relationship = startNode.createRelationshipTo(endNode, RelationshipType.withName((String)type));
            tx.commit();
            long l = relationship.getId();
            return l;
        }
    }

    public long createRelationship(String type) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.writeToken());){
            Node startNode = tx.createNode();
            Node endNode = tx.createNode();
            Relationship relationship = startNode.createRelationshipTo(endNode, RelationshipType.withName((String)type));
            tx.commit();
            long l = relationship.getId();
            return l;
        }
    }

    public void setRelationshipProperties(long relationshipId, Map<String, Object> properties) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.writeToken());){
            Relationship relationship = tx.getRelationshipById(relationshipId);
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                relationship.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            tx.commit();
        }
    }

    public Map<String, Object> getRelationshipProperties(long relationshipId) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.read());){
            Relationship relationship = tx.getRelationshipById(relationshipId);
            Map allProperties = relationship.getAllProperties();
            tx.commit();
            Map map = allProperties;
            return map;
        }
    }

    public Relationship getRelationship(long relationshipId) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.read());){
            Relationship relationship = tx.getRelationshipById(relationshipId);
            tx.commit();
            Relationship relationship2 = relationship;
            return relationship2;
        }
    }

    public long getFirstNode() {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.write());){
            Node referenceNode = tx.getNodeById(0L);
            tx.commit();
            long l = referenceNode.getId();
            return l;
        }
    }

    public Iterable<String> getNodeLabels(Transaction tx, long node) {
        return new IterableWrapper<String, Label>(tx.getNodeById(node).getLabels()){

            protected String underlyingObjectToObject(Label object) {
                return object.name();
            }
        };
    }

    public void addLabelToNode(long node, String labelName) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.writeToken());){
            tx.getNodeById(node).addLabel(Label.label((String)labelName));
            tx.commit();
        }
    }

    public IndexDefinition createSchemaIndex(String labelName, String propertyKey) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, LoginContext.AUTH_DISABLED);){
            IndexDefinition index = tx.schema().indexFor(Label.label((String)labelName)).on(propertyKey).create();
            tx.commit();
            IndexDefinition indexDefinition = index;
            return indexDefinition;
        }
    }

    public Iterable<ConstraintDefinition> getPropertyUniquenessConstraints(String labelName, String propertyKey) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.read());){
            Iterable definitions = Iterables.filter(item -> {
                if (item.isConstraintType(ConstraintType.UNIQUENESS)) {
                    Iterable keys = item.getPropertyKeys();
                    return ((String)Iterables.single((Iterable)keys)).equals(propertyKey);
                }
                return false;
            }, (Iterable)tx.schema().getConstraints(Label.label((String)labelName)));
            tx.commit();
            Iterable iterable = definitions;
            return iterable;
        }
    }

    public ConstraintDefinition createPropertyUniquenessConstraint(String labelName, List<String> propertyKeys) {
        try (InternalTransaction tx = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, LoginContext.AUTH_DISABLED);){
            ConstraintCreator creator = tx.schema().constraintFor(Label.label((String)labelName));
            for (String propertyKey : propertyKeys) {
                creator = creator.assertPropertyIsUnique(propertyKey);
            }
            ConstraintDefinition result = creator.create();
            tx.commit();
            ConstraintDefinition constraintDefinition = result;
            return constraintDefinition;
        }
    }

    public long getLabelCount(long nodeId) {
        try (InternalTransaction transaction = this.database.getDatabase().beginTransaction(KernelTransaction.Type.implicit, (LoginContext)AnonymousContext.read());){
            long l = Iterables.count((Iterable)transaction.getNodeById(nodeId).getLabels());
            return l;
        }
    }
}

