/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.rest.discovery.ServerVersionAndEdition;
import org.neo4j.server.rest.repr.DiscoveryRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;
import org.neo4j.server.rest.repr.RepresentationTestBase;
import org.neo4j.server.rest.repr.Serializer;

public class DiscoveryRepresentationTest {
    @Test
    public void shouldCreateAMapContainingDataAndManagementURIs() throws URISyntaxException {
        URI baseUri = RepresentationTestBase.BASE_URI;
        String managementUri = "/management";
        String dataUri = "/data";
        Config config = Config.defaults((Setting)BoltConnector.enabled, (Object)true);
        DiscoveryRepresentation dr = new DiscoveryRepresentation(new DiscoverableURIs.Builder().addEndpoint("management", managementUri).addEndpoint("data", dataUri).addBoltEndpoint(config, (ConnectorPortRegister)Mockito.mock(ConnectorPortRegister.class)).build().update(baseUri), (ServerVersionAndEdition)Mockito.mock(ServerVersionAndEdition.class));
        Map<String, Object> mapOfUris = RepresentationTestAccess.serialize((MappingRepresentation)dr);
        Object mappedManagementUri = mapOfUris.get("management");
        Object mappedDataUri = mapOfUris.get("data");
        Object mappedBoltUri = mapOfUris.get("bolt_direct");
        Assert.assertNotNull((Object)mappedManagementUri);
        Assert.assertNotNull((Object)mappedDataUri);
        Assert.assertNotNull((Object)mappedBoltUri);
        Assert.assertEquals((Object)Serializer.joinBaseWithRelativePath((URI)baseUri, (String)managementUri), (Object)mappedManagementUri.toString());
        Assert.assertEquals((Object)Serializer.joinBaseWithRelativePath((URI)baseUri, (String)dataUri), (Object)mappedDataUri.toString());
        Assert.assertEquals((Object)"bolt://neo4j.org:7687", (Object)mappedBoltUri.toString());
    }

    @Test
    public void shouldCreateAMapContainingServerVersionAndEditionInfo() throws URISyntaxException {
        ServerVersionAndEdition serverInfo = new ServerVersionAndEdition("myVersion", "myEdition");
        DiscoveryRepresentation dr = new DiscoveryRepresentation((DiscoverableURIs)Mockito.mock(DiscoverableURIs.class), serverInfo);
        Map<String, Object> mapOfUris = RepresentationTestAccess.serialize((MappingRepresentation)dr);
        Object version = mapOfUris.get("neo4j_version");
        Object edition = mapOfUris.get("neo4j_edition");
        Assert.assertNotNull((Object)version);
        Assert.assertNotNull((Object)edition);
        Assert.assertEquals((Object)"myVersion", (Object)version.toString());
        Assert.assertEquals((Object)"myEdition", (Object)edition.toString());
    }
}

