/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.annotations.documented.Documented;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.security.CommunityServerTestBase;
import org.neo4j.test.TestData;
import org.neo4j.test.server.HTTP;

public class AuthenticationIT
extends CommunityServerTestBase {
    @Rule
    public TestData<RESTRequestGenerator> gen = TestData.producedThrough(RESTRequestGenerator.PRODUCER);

    @Test
    @Documented(value="Missing authorization\n\nIf an +Authorization+ header is not supplied, the server will reply with an error.")
    public void missing_authorization() throws JsonParseException, IOException {
        this.startServerWithConfiguredUser();
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(401).expectedHeader("WWW-Authenticate", "Basic realm=\"Neo4j\"").get(this.databaseURL());
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        JsonNode firstError = data.get("errors").get(0);
        Assert.assertThat((Object)firstError.get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)Status.Security.Unauthorized.code().serialize()));
        Assert.assertThat((Object)firstError.get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"No authentication header supplied."));
    }

    @Test
    @Documented(value="Authenticate to access the server\n\nAuthenticate by sending a username and a password to Neo4j using HTTP Basic Auth.\nRequests should include an +Authorization+ header, with a value of +Basic <payload>+,\nwhere \"payload\" is a base64 encoded string of \"username:password\".")
    public void successful_authentication() throws JsonParseException, IOException {
        this.startServerWithConfiguredUser();
        HTTP.Response response = HTTP.withBasicAuth("neo4j", "secret").POST(this.txCommitURL("system"), AuthenticationIT.query("SHOW USERS"));
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        JsonNode jsonNode = this.getResultRow(response);
        Assert.assertThat((Object)jsonNode.get(0).asText(), (Matcher)CoreMatchers.equalTo((Object)"neo4j"));
        Assert.assertThat((Object)jsonNode.get(1).asBoolean(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    @Documented(value="Incorrect authentication\n\nIf an incorrect username or password is provided, the server replies with an error.")
    public void incorrect_authentication() throws JsonParseException, IOException {
        this.startServerWithConfiguredUser();
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(401).withHeader("Authorization", HTTP.basicAuthHeader("neo4j", "incorrect")).expectedHeader("WWW-Authenticate", "Basic realm=\"Neo4j\"").post(this.databaseURL());
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        JsonNode firstError = data.get("errors").get(0);
        Assert.assertThat((Object)firstError.get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)Status.Security.Unauthorized.code().serialize()));
        Assert.assertThat((Object)firstError.get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"Invalid username or password."));
    }

    @Test
    @Documented(value="Required password changes\n\nIn some cases, like the very first time Neo4j is accessed, the user will be required to choose\na new password. The database will signal that a new password is required and deny access.\n\nSee <<rest-api-security-user-status-and-password-changing>> for how to set a new password.")
    public void password_change_required() throws JsonParseException, IOException {
        this.startServer(true);
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).withHeader("Authorization", HTTP.basicAuthHeader("neo4j", "neo4j"));
        HTTP.Response responseBeforePasswordChange = HTTP.withBasicAuth("neo4j", "neo4j").POST(this.txCommitURL("system"), AuthenticationIT.query("SHOW USERS"));
        this.assertPermissionErrorAtSystemAccess(responseBeforePasswordChange);
        HTTP.Response response = HTTP.withBasicAuth("neo4j", "neo4j").POST(this.txCommitURL("system"), AuthenticationIT.query("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO 'secret'"));
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((String)"Should have no errors", (Object)response.get("errors").size(), (Matcher)CoreMatchers.equalTo((Object)0));
        HTTP.Response responseAfterPasswordChange = HTTP.withBasicAuth("neo4j", "secret").POST(this.txCommitURL("system"), AuthenticationIT.query("SHOW USERS"));
        Assert.assertThat((Object)responseAfterPasswordChange.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((String)"Should have no errors", (Object)response.get("errors").size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void shouldSayMalformedHeaderIfMalformedAuthorization() throws Exception {
        this.startServerWithConfiguredUser();
        HTTP.Response response = HTTP.withHeaders("Authorization", "This makes no sense").GET(this.databaseURL());
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertThat((Object)response.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)Status.Request.InvalidFormat.code().serialize()));
        Assert.assertThat((Object)response.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"Invalid authentication header."));
    }

    @Test
    public void shouldAllowDataAccess() throws Exception {
        this.startServerWithConfiguredUser();
        this.assertAuthorizationRequired("POST", AuthenticationIT.txCommitEndpoint(), HTTP.RawPayload.quotedJson("{'statements':[{'statement':'MATCH (n) RETURN n'}]}"), 200);
        this.assertAuthorizationRequired("GET", "db/data/nowhere", null, 404);
        Assert.assertEquals((long)200L, (long)HTTP.GET(this.server.baseUri().resolve("").toString()).status());
    }

    @Test
    public void shouldAllowAllAccessIfAuthenticationIsDisabled() throws Exception {
        this.startServer(false);
        Assert.assertEquals((long)200L, (long)HTTP.POST(this.txCommitURL(), HTTP.RawPayload.quotedJson("{'statements':[{'statement':'MATCH (n) RETURN n'}]}")).status());
        Assert.assertEquals((long)404L, (long)HTTP.GET(this.server.baseUri().resolve("db/data/nowhere").toString()).status());
    }

    @Test
    public void shouldReplyNicelyToTooManyFailedAuthAttempts() throws Exception {
        this.startServerWithConfiguredUser();
        long timeout = System.currentTimeMillis() + 30000L;
        HTTP.Response response = null;
        while (System.currentTimeMillis() < timeout && (response = HTTP.withBasicAuth("neo4j", "incorrect").POST(this.server.baseUri().resolve("authentication").toString(), HTTP.RawPayload.quotedJson("{'username':'neo4j', 'password':'something that is wrong'}"))).status() != 429) {
        }
        Assert.assertNotNull(response);
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)429));
        JsonNode firstError = response.get("errors").get(0);
        Assert.assertThat((Object)firstError.get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)Status.Security.AuthenticationRateLimit.code().serialize()));
        Assert.assertThat((Object)firstError.get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"Too many failed authentication requests. Please wait 5 seconds and try again."));
    }

    @Test
    public void shouldNotAllowDataAccessWhenPasswordChangeRequired() throws Exception {
        this.startServer(true);
        HTTP.Response response = HTTP.withBasicAuth("neo4j", "neo4j").POST(this.server.baseUri().resolve(this.txCommitURL()).toString(), HTTP.RawPayload.quotedJson("{'statements':[{'statement':'MATCH (n) RETURN n'}]}"));
        this.assertPermissionErrorAtDataAccess(response);
    }

    private void assertAuthorizationRequired(String method, String path, Object payload, int expectedAuthorizedStatus) throws JsonParseException {
        HTTP.Response response = HTTP.request(method, this.server.baseUri().resolve(path).toString(), payload);
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)401));
        Assert.assertThat((Object)response.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)Status.Security.Unauthorized.code().serialize()));
        Assert.assertThat((Object)response.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"No authentication header supplied."));
        Assert.assertThat((Object)response.header("WWW-Authenticate"), (Matcher)CoreMatchers.equalTo((Object)"Basic realm=\"Neo4j\""));
        response = HTTP.withHeaders("Authorization", "This makes no sense").request(method, this.server.baseUri().resolve(path).toString(), payload);
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)400));
        Assert.assertThat((Object)response.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)Status.Request.InvalidFormat.code().serialize()));
        Assert.assertThat((Object)response.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"Invalid authentication header."));
        response = HTTP.withBasicAuth("neo4j", "incorrect").request(method, this.server.baseUri().resolve(path).toString(), payload);
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)401));
        Assert.assertThat((Object)response.get("errors").get(0).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)Status.Security.Unauthorized.code().serialize()));
        Assert.assertThat((Object)response.get("errors").get(0).get("message").asText(), (Matcher)CoreMatchers.equalTo((Object)"Invalid username or password."));
        Assert.assertThat((Object)response.header("WWW-Authenticate"), (Matcher)CoreMatchers.equalTo((Object)"Basic realm=\"Neo4j\""));
        response = HTTP.withBasicAuth("neo4j", "secret").request(method, this.server.baseUri().resolve(path).toString(), payload);
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)expectedAuthorizedStatus));
    }

    protected void startServerWithConfiguredUser() throws IOException {
        this.startServer(true);
        HTTP.Response post = HTTP.withBasicAuth("neo4j", "neo4j").POST(this.txCommitURL("system"), AuthenticationIT.query("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO 'secret'"));
        Assert.assertEquals((long)200L, (long)post.status());
    }

    private JsonNode getResultRow(HTTP.Response response) throws JsonParseException {
        return response.get("results").get(0).get("data").get(0).get("row");
    }
}

