/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.security.CommunityServerTestBase;
import org.neo4j.server.web.HttpMethod;
import org.neo4j.test.server.HTTP;

public class AuthorizationCorsIT
extends CommunityServerTestBase {
    @Test
    public void shouldAddCorsHeaderWhenAuthDisabled() throws Exception {
        this.startServer(false);
        HTTP.Response response = this.runQuery("authDisabled", "authDisabled");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(response);
        Assert.assertThat((Object)response.content().toString(), (Matcher)Matchers.containsString((String)"42"));
    }

    @Test
    public void shouldAddCorsHeaderWhenAuthEnabledAndPasswordChangeRequired() throws Exception {
        this.startServer(true);
        HTTP.Response response = this.runQuery("neo4j", "neo4j");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(response);
        this.assertPermissionErrorAtDataAccess(response);
    }

    @Test
    public void shouldAddCorsHeaderWhenAuthEnabledAndPasswordChangeNotRequired() throws Exception {
        this.startServer(true);
        HTTP.Response passwordChangeResponse = this.changePassword("neo4j", "neo4j", "newPassword");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)passwordChangeResponse.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(passwordChangeResponse);
        HTTP.Response queryResponse = this.runQuery("neo4j", "newPassword");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)queryResponse.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(queryResponse);
        Assert.assertThat((Object)queryResponse.content().toString(), (Matcher)Matchers.containsString((String)"42"));
    }

    @Test
    public void shouldAddCorsHeaderWhenAuthEnabledAndIncorrectPassword() throws Exception {
        this.startServer(true);
        HTTP.Response response = this.runQuery("neo4j", "wrongPassword");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(response);
        Assert.assertThat((Object)response.content().toString(), (Matcher)Matchers.containsString((String)"Neo.ClientError.Security.Unauthorized"));
    }

    @Test
    public void shouldAddCorsMethodsHeader() throws Exception {
        this.startServer(false);
        this.testCorsAllowMethods(HttpMethod.POST);
        this.testCorsAllowMethods(HttpMethod.GET);
        this.testCorsAllowMethods(HttpMethod.PATCH);
        this.testCorsAllowMethods(HttpMethod.DELETE);
    }

    @Test
    public void shouldAddCorsHeaderWhenConfigured() throws Exception {
        String origin = "https://example.com:7687";
        this.startServer(false, origin);
        this.testCorsAllowMethods(HttpMethod.POST, origin);
        this.testCorsAllowMethods(HttpMethod.GET, origin);
        this.testCorsAllowMethods(HttpMethod.PATCH, origin);
        this.testCorsAllowMethods(HttpMethod.DELETE, origin);
    }

    @Test
    public void shouldAddCorsRequestHeaders() throws Exception {
        this.startServer(false);
        HTTP.Builder requestBuilder = HTTP.withBasicAuth("authDisabled", "authDisabled").withHeaders("Access-Control-Request-Headers", "Accept, X-Not-Accept");
        HTTP.Response response = this.runQuery(requestBuilder);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(response);
        Assert.assertEquals((Object)"Accept, X-Not-Accept", (Object)response.header("Access-Control-Allow-Headers"));
    }

    private void testCorsAllowMethods(HttpMethod method) throws Exception {
        this.testCorsAllowMethods(method, "*");
    }

    private void testCorsAllowMethods(HttpMethod method, String origin) throws Exception {
        HTTP.Builder requestBuilder = HTTP.withBasicAuth("authDisabled", "authDisabled").withHeaders("Access-Control-Request-Method", method.toString());
        HTTP.Response response = this.runQuery(requestBuilder);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.status());
        AuthorizationCorsIT.assertCorsHeaderEquals(response, origin);
        Assert.assertEquals((Object)method, (Object)HttpMethod.valueOf((String)response.header("Access-Control-Allow-Methods")));
    }

    private HTTP.Response changePassword(String username, String oldPassword, String newPassword) {
        HTTP.RawPayload passwordChange = AuthorizationCorsIT.query(String.format("ALTER CURRENT USER SET PASSWORD FROM '%s' TO '%s'", oldPassword, newPassword));
        return HTTP.withBasicAuth(username, oldPassword).POST(this.txCommitURL("system"), passwordChange);
    }

    private HTTP.Response runQuery(String username, String password) {
        return this.runQuery(HTTP.withBasicAuth(username, password));
    }

    private HTTP.Response runQuery(HTTP.Builder requestBuilder) {
        HTTP.RawPayload statements = HTTP.RawPayload.quotedJson("{'statements': [{'statement': 'RETURN 42'}]}");
        return requestBuilder.POST(this.txCommitURL(), statements);
    }

    private static void assertCorsHeaderPresent(HTTP.Response response) {
        AuthorizationCorsIT.assertCorsHeaderEquals(response, "*");
    }

    private static void assertCorsHeaderEquals(HTTP.Response response, String origin) {
        Assert.assertEquals((Object)origin, (Object)response.header("Access-Control-Allow-Origin"));
    }
}

