/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionLifecycleException;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.http.cypher.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;

class TransactionFacade {
    private final TransitionalPeriodTransactionMessContainer kernel;
    private final QueryExecutionEngine engine;
    private final TransactionRegistry registry;
    private final GraphDatabaseQueryService queryService;

    TransactionFacade(TransitionalPeriodTransactionMessContainer kernel, QueryExecutionEngine engine, GraphDatabaseQueryService queryService, TransactionRegistry registry) {
        this.kernel = kernel;
        this.engine = engine;
        this.queryService = queryService;
        this.registry = registry;
    }

    TransactionHandle newTransactionHandle(TransactionUriScheme uriScheme, boolean implicitTransaction, LoginContext loginContext, ClientConnectionInfo connectionInfo, long customTransactionTimeout) {
        return new TransactionHandle(this.kernel, this.engine, this.queryService, this.registry, uriScheme, implicitTransaction, loginContext, connectionInfo, customTransactionTimeout);
    }

    TransactionHandle findTransactionHandle(long txId) throws TransactionLifecycleException {
        return this.registry.acquire(txId);
    }

    TransactionHandle terminate(long txId) throws TransactionLifecycleException {
        return this.registry.terminate(txId);
    }

    TransitionalPeriodTransactionMessContainer getTransactionContainer() {
        return this.kernel;
    }
}

