/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.http.cypher.TransitionalTxManagementKernelTransaction;

class TransitionalTxManagementKernelTransactionTest {
    private final GraphDatabaseFacade databaseFacade = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
    private final LoginContext loginContext = AnonymousContext.read();
    private final KernelTransaction.Type type = KernelTransaction.Type.implicit;

    TransitionalTxManagementKernelTransactionTest() {
    }

    @Test
    void reopenStartTransactionWithCustomTimeoutIfSpecified() {
        TransitionalTxManagementKernelTransaction managementKernelTransaction = new TransitionalTxManagementKernelTransaction(this.databaseFacade, this.type, this.loginContext, ClientConnectionInfo.EMBEDDED_CONNECTION, 10L);
        managementKernelTransaction.reopenAfterPeriodicCommit();
        ((GraphDatabaseFacade)Mockito.verify((Object)this.databaseFacade, (VerificationMode)Mockito.times((int)2))).beginTransaction(this.type, this.loginContext, ClientConnectionInfo.EMBEDDED_CONNECTION, 10L, TimeUnit.MILLISECONDS);
    }

    @Test
    void reopenStartDefaultTransactionIfTimeoutNotSpecified() {
        TransitionalTxManagementKernelTransaction managementKernelTransaction = new TransitionalTxManagementKernelTransaction(this.databaseFacade, this.type, this.loginContext, ClientConnectionInfo.EMBEDDED_CONNECTION, -1L);
        managementKernelTransaction.reopenAfterPeriodicCommit();
        ((GraphDatabaseFacade)Mockito.verify((Object)this.databaseFacade, (VerificationMode)Mockito.times((int)2))).beginTransaction(this.type, this.loginContext, ClientConnectionInfo.EMBEDDED_CONNECTION);
    }
}

